package net.invictusslayer.slayersbeasts.world.level.gen.structure.pieces;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import net.minecraft.class_9822;
import net.minecraft.core.*;
import org.apache.commons.lang3.mutable.MutableObject;

import java.util.Deque;
import java.util.List;
import java.util.Optional;

public class CryptPieces {
	public static Optional<class_3195.class_7150> addPieces(class_3195.class_7149 context, class_6880<class_3785> start, class_2338 pos, int maxDistanceFromCenter) {
		class_5455 access = context.comp_561();
		class_2794 chunkGen = context.comp_562();
		class_3485 manager = context.comp_565();
		class_5539 heightAccessor = context.comp_569();
		class_2919 random = context.comp_566();
		class_2378<class_3785> registry = access.method_30530(class_7924.field_41249);
		class_3785 pool = start.comp_349();
		class_3784 element = pool.method_16631(random);

		class_2382 vec3i = pos.method_10059(pos);
		class_2338 blockPos = pos.method_10059(vec3i);
		class_3790 piece = new class_3790(manager, element, blockPos, element.method_19308(), class_2470.field_11467, element.method_16628(manager, blockPos, class_2470.field_11467), class_9822.field_52237);
		class_3341 box = piece.method_14935();
		int x = (box.method_35418() + box.method_35415()) / 2;
		int z = (box.method_35420() + box.method_35417()) / 2;
		int y = vec3i.method_10264();

		return Optional.of(new class_3195.class_7150(new class_2338(x, y, z), builder -> {
			List<class_3790> list = Lists.newArrayList();
			list.add(piece);
			class_238 aabb = new class_238(x - maxDistanceFromCenter, y - maxDistanceFromCenter, z - maxDistanceFromCenter, x + maxDistanceFromCenter + 1, y + maxDistanceFromCenter + 1, z + maxDistanceFromCenter + 1);
			class_265 shape = class_259.method_1072(class_259.method_1078(aabb), class_259.method_1078(class_238.method_19316(box)), class_247.field_16886);
			addPieces(context.comp_564(), chunkGen, manager, heightAccessor, random, registry, piece, list, shape);
			list.forEach(builder::method_35462);
		}));

	}

	private static void addPieces(class_7138 pRandomState, class_2794 pChunkGenerator, class_3485 pStructureTemplateManager, class_5539 pLevel, class_5819 pRandom, class_2378<class_3785> pPools, class_3790 p_227219_, List<class_3790> pPieces, class_265 p_227221_) {
		Placer placer = new Placer(pPools, 7, pChunkGenerator, pStructureTemplateManager, pPieces, pRandom);
		placer.placing.addLast(new PieceState(p_227219_, new MutableObject<>(p_227221_), 0));

		while (!placer.placing.isEmpty()) {
			PieceState pieceState = placer.placing.removeFirst();
			placer.tryPlacingChildren(pieceState.piece, pieceState.free, pieceState.depth, pLevel, pRandomState);
		}

	}

	record PieceState(class_3790 piece, MutableObject<class_265> free, int depth) {}

	private static final class Placer {
		private final class_2378<class_3785> pools;
		private final int maxDepth;
		private final class_2794 chunkGen;
		private final class_3485 manager;
		private final List<? super class_3790> pieces;
		private final class_5819 random;
		final Deque<CryptPieces.PieceState> placing = Queues.newArrayDeque();

		Placer(class_2378<class_3785> pools, int maxDepth, class_2794 chunkGen, class_3485 manager, List<? super class_3790> pieces, class_5819 random) {
			this.pools = pools;
			this.maxDepth = maxDepth;
			this.chunkGen = chunkGen;
			this.manager = manager;
			this.pieces = pieces;
			this.random = random;
		}

		void tryPlacingChildren(class_3790 piece, MutableObject<class_265> free, int depth, class_5539 pLevel, class_7138 pRandomState) {
			class_3784 element = piece.method_16644();
			class_2338 pos = piece.method_16648();
			class_2470 rotation = piece.method_16888();
			class_3785.class_3786 projection1 = element.method_16624();
			boolean flag = projection1 == class_3785.class_3786.field_16687;
			MutableObject<class_265> mutableShape = new MutableObject<>();
			class_3341 box = piece.method_14935();
			int y = box.method_35416();

			loop:
			for (class_3499.class_3501 info : element.method_16627(this.manager, pos, rotation, this.random)) {
				class_2350 direction = class_3748.method_26378(info.comp_1342());
				class_2338 blockPos = info.comp_1341();
				class_2338 blockPos1 = blockPos.method_10093(direction);
				int j = blockPos.method_10264() - y;
				int k = -1;
				class_5321<class_3785> poolName = readPoolName(info);
				Optional<? extends class_6880<class_3785>> optional = this.pools.method_40264(poolName);
				if (optional.isEmpty()) {
					LogUtils.getLogger().warn("Empty or non-existent pool: {}", poolName.method_29177());
				}

				class_6880<class_3785> holder = optional.get();
				if (holder.comp_349().method_16632() == 0 && !holder.method_40225(class_5468.field_26254)) {
					LogUtils.getLogger().warn("Empty or non-existent pool: {}", poolName.method_29177());
				}

				class_6880<class_3785> holder1 = holder.comp_349().method_46736();
				if (holder1.comp_349().method_16632() == 0 && !holder1.method_40225(class_5468.field_26254)) {
					LogUtils.getLogger().warn("Empty or non-existent fallback pool: {}", holder1.method_40230().map((p_255599_) -> p_255599_.method_29177().toString()).orElse("<unregistered>"));
				}

				MutableObject<class_265> mutableObject;
				if (box.method_14662(blockPos1)) {
					mutableObject = mutableShape;
					if (mutableShape.getValue() == null) {
						mutableShape.setValue(class_259.method_1078(class_238.method_19316(box)));
					}
				} else {
					mutableObject = free;
				}

				List<class_3784> list = Lists.newArrayList();
				if (depth != this.maxDepth) {
					list.addAll(holder.comp_349().method_16633(this.random));
				}

				list.addAll(holder1.comp_349().method_16633(this.random));

				for (class_3784 poolElement : list) {
					if (poolElement == class_3777.field_16663) {
						break;
					}

					for (class_2470 rotation1 : class_2470.method_16547(this.random)) {
						List<class_3499.class_3501> list1 = poolElement.method_16627(this.manager, class_2338.field_10980, rotation1, this.random);

						for (class_3499.class_3501 info1 : list1) {
							if (class_3748.method_16546(info, info1)) {
								class_2338 blockPos2 = info1.comp_1341();
								class_2338 blockPos3 = blockPos1.method_10059(blockPos2);
								class_3341 boundingBox = poolElement.method_16628(this.manager, blockPos3, rotation1);
								int i1 = boundingBox.method_35416();
								class_3785.class_3786 projection = poolElement.method_16624();
								boolean flag2 = projection == class_3785.class_3786.field_16687;
								int j1 = blockPos2.method_10264();
								int k1 = j - j1 + class_3748.method_26378(info.comp_1342()).method_10164();
								int l1;
								if (flag && flag2) {
									l1 = y + k1;
								} else {
									if (k == -1) {
										k = this.chunkGen.method_20402(blockPos.method_10263(), blockPos.method_10260(), class_2902.class_2903.field_13194, pLevel, pRandomState);
									}

									l1 = k - j1;
								}

								int i2 = l1 - i1;
								class_3341 boundingBox1 = boundingBox.method_19311(0, i2, 0);
								class_2338 blockPos4 = blockPos3.method_10069(0, i2, 0);

								if (!class_259.method_1074(mutableObject.getValue(), class_259.method_1078(class_238.method_19316(boundingBox1).method_1011(0.25D)), class_247.field_16893)) {
									mutableObject.setValue(class_259.method_1082(mutableObject.getValue(), class_259.method_1078(class_238.method_19316(boundingBox1)), class_247.field_16886));
									int i3 = piece.method_16646();
									int k2;
									if (flag2) {
										k2 = i3 - k1;
									} else {
										k2 = poolElement.method_19308();
									}

									class_3790 piece1 = new class_3790(this.manager, poolElement, blockPos4, k2, rotation1, boundingBox1, class_9822.field_52237);
									int l2;
									if (flag) {
										l2 = y + j;
									} else if (flag2) {
										l2 = l1 + j1;
									} else {
										if (k == -1) {
											k = this.chunkGen.method_20402(blockPos.method_10263(), blockPos.method_10260(), class_2902.class_2903.field_13194, pLevel, pRandomState);
										}

										l2 = k + k1 / 2;
									}

									piece.method_16647(new class_3780(blockPos1.method_10263(), l2 - j + i3, blockPos1.method_10260(), k1, projection));
									piece1.method_16647(new class_3780(blockPos.method_10263(), l2 - j1 + k2, blockPos.method_10260(), -k1, projection1));
									this.pieces.add(piece1);
									if (depth + 1 <= this.maxDepth) {
										this.placing.addLast(new PieceState(piece1, mutableObject, depth + 1));
									}
									continue loop;
								}
							}
						}
					}
				}
			}
		}

		private static class_5321<class_3785> readPoolName(class_3499.class_3501 info) {
			assert info.comp_1343() != null;
			return class_5321.method_29179(class_7924.field_41249, class_2960.method_60654(info.comp_1343().method_10558("pool")));
		}
	}
}
