package net.invictusslayer.slayersbeasts.world.level.gen.structure.pieces;

import net.invictusslayer.slayersbeasts.world.level.block.InfusedCryptalithBlock;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBStructurePieces;

public class CryptPortalPieces {
	public static void addPieces(class_6626 builder, class_5819 random, int x, int y, int z) {
		builder.method_35462(PortalPiece.createPiece(random, x, y, z));
		builder.method_35462(BasePiece.createPiece(x - 1, y - 1, z + 1));
	}

	public static class PortalPiece extends class_3443 {
		public PortalPiece(class_3341 box, class_2350 direction) {
			super(SBStructurePieces.CRYPT_PORTAL.get(), 0, box);
			method_14926(direction);
		}

		public PortalPiece(class_2487 tag) {
			super(SBStructurePieces.CRYPT_PORTAL.get(), tag);
		}
		
		private static PortalPiece createPiece(class_5819 random, int x, int y, int z) {
			boolean hasTop = random.method_43056();
			class_3341 box = class_3341.method_14667(x, y, z, 0, 1, 0, 3, hasTop ? 6 : 1, 3, class_2350.field_11043);
			return new PortalPiece(box, class_2350.field_11043);
		}

		protected void method_14943(class_6625 context, class_2487 tag) {
		}

		public void method_14931(class_5281 level, class_5138 manager, class_2794 chunkGen, class_5819 random, class_3341 box, class_1923 chunkPos, class_2338 pos) {
			class_2680 cryptalith = SBBlocks.CRYPTALITH.get().method_9564();
			class_2680 air = class_2246.field_10543.method_9564();
			class_2680 north = SBBlocks.INFUSED_CRYPTALITH.get().method_9564().method_11657(InfusedCryptalithBlock.FACING, class_2350.field_11043);
			class_2680 east = SBBlocks.INFUSED_CRYPTALITH.get().method_9564().method_11657(InfusedCryptalithBlock.FACING, class_2350.field_11034);
			class_2680 south = SBBlocks.INFUSED_CRYPTALITH.get().method_9564().method_11657(InfusedCryptalithBlock.FACING, class_2350.field_11035);
			class_2680 west = SBBlocks.INFUSED_CRYPTALITH.get().method_9564().method_11657(InfusedCryptalithBlock.FACING, class_2350.field_11039);

			method_14940(level, box, 0, -1, 0, 3, field_15315.method_14660() - 1, 3, cryptalith, air, false);
			method_14940(level, box, 1, 0, 1, 2, 0, 2, air, air, false);
			method_14940(level, box, 0, 1, 1, 0, 3, 2, air, air, false);
			method_14940(level, box, 1, 1, 0, 2, 3, 0, air, air, false);
			method_14940(level, box, 3, 1, 1, 3, 3, 2, air, air, false);
			method_14940(level, box, 1, 1, 3, 2, 3, 3, air, air, false);
			method_14917(level, air, 0, 5, 0, box);
			method_14917(level, air, 0, 5, 3, box);
			method_14917(level, air, 3, 5, 3, box);
			method_14917(level, air, 3, 5, 0, box);

			method_14917(level, north, 1, 0, 0, box);
			method_14917(level, north, 2, 0, 0, box);
			method_14917(level, east, 0, 0, 2, box);
			method_14917(level, east, 0, 0, 1, box);
			method_14917(level, south, 2, 0, 3, box);
			method_14917(level, south, 1, 0, 3, box);
			method_14917(level, west, 3, 0, 1, box);
			method_14917(level, west, 3, 0, 2, box);
		}
	}

	public static class BasePiece extends class_3443 {
		public BasePiece(class_3341 box, class_2350 direction) {
			super(SBStructurePieces.CRYPT_PORTAL_BASE.get(), 0, box);
			method_14926(direction);
		}

		public BasePiece(class_2487 tag) {
			super(SBStructurePieces.CRYPT_PORTAL_BASE.get(), tag);
		}

		private static BasePiece createPiece(int x, int y, int z) {
			class_3341 box = class_3341.method_14667(x, y, z, 0, 1, 0, 5, 1, 5, class_2350.field_11043);
			return new BasePiece(box, class_2350.field_11043);
		}

		protected void method_14943(class_6625 context, class_2487 tag) {
		}

		public void method_14931(class_5281 level, class_5138 manager, class_2794 chunkGen, class_5819 random, class_3341 box, class_1923 chunkPos, class_2338 pos) {
			class_2680 cryptalith = SBBlocks.CRYPTALITH.get().method_9564();

			method_14940(level, box, 0, 0, 0, 5, 0, 5, cryptalith, cryptalith, false);
		}
	}
}
