package net.invictusslayer.slayersbeasts.world.level.gen.structure.pools;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBProcessorLists;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5468;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import java.util.function.Function;

public class CryptPools extends SBPools {
	public static final class_5321<class_3785> START = createKey("entrance");
	private static final class_5321<class_3785> CORRIDOR = createKey("corridor");
	private static final class_5321<class_3785> JUNCTION = createKey("junction");
	private static final class_5321<class_3785> ROOM = createKey("room");
	private static final class_5321<class_3785> WALL = createKey("wall");

	public static void bootstrap(class_7891<class_3785> context) {
		class_7871<class_3785> pools = context.method_46799(class_7924.field_41249);
		class_7871<class_5497> processors = context.method_46799(class_7924.field_41247);

		register(context, START, pools.method_46747(class_5468.field_26254), class_3785.class_3786.field_16687, ImmutableList.of(element("entrance1", 1)));
		register(context, CORRIDOR, pools.method_46747(ROOM), class_3785.class_3786.field_16687, ImmutableList.of(element("corridor_0", 2), element("corridor_1", 1), element("corridor_2", 2)));
		register(context, JUNCTION, pools.method_46747(ROOM), class_3785.class_3786.field_16687, ImmutableList.of(element("junction_0", 2, processors.method_46747(SBProcessorLists.STONE_FLOOR)), element("junction_1", 1, processors.method_46747(SBProcessorLists.STONE_FLOOR)), element("junction1", 1), element("junction_stair1", 1)));
		register(context, ROOM, pools.method_46747(WALL), class_3785.class_3786.field_16687, ImmutableList.of(element("room_chest_0", 1, processors.method_46747(SBProcessorLists.STONE_FLOOR)), element("room_spawner_0", 1)));
		register(context, WALL, pools.method_46747(class_5468.field_26254), class_3785.class_3786.field_16687, ImmutableList.of(element("wall_0", 2), element("wall_1", 2), element("wall_2", 2), element("wall_barrels_0", 1), element("wall_barrels_1", 1), element("wall_fountain_0", 1)));
	}

	private static Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer> element(String name, int weight) {
		return parentElement("crypt", name, weight);
	}

	private static Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer> element(String name, int weight, class_6880<class_5497> processor) {
		return parentElement("crypt", name, weight, processor);
	}

	private static class_5321<class_3785> createKey(String name) {
		return createParentKey("crypt", name);
	}
}
