package net.invictusslayer.slayersbeasts.world.level.gen.structure.structures;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.registries.SBStructureTypes;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.pieces.CryptPieces;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import java.util.Optional;

public class CryptStructure extends class_3195 {
	public static final MapCodec<CryptStructure> CODEC = RecordCodecBuilder.mapCodec(instance ->
			instance.group(method_42697(instance),
							class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool),
							class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight))
					.apply(instance, CryptStructure::new));
	private final class_6880<class_3785> startPool;
	private final class_6122 startHeight;

	public CryptStructure(class_7302 settings, class_6880<class_3785> startPool, class_6122 startHeight) {
		super(settings);
		this.startPool = startPool;
		this.startHeight = startHeight;
	}

	public Optional<class_7150> method_38676(class_7149 context) {
		class_1923 chunkPos = context.comp_568();
		int i = startHeight.method_35391(context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
		class_2338 pos = new class_2338(chunkPos.method_8326(), i, chunkPos.method_8328());
		return CryptPieces.addPieces(context, startPool, pos, 128);
	}

	public class_7151<?> method_41618() {
		return SBStructureTypes.CRYPT.get();
	}
}
