/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.model;

import net.invictusslayer.slayersbeasts.client.animation.DamselflyAnimation;
import net.invictusslayer.slayersbeasts.client.state.DamselflyRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class DamselflyModel
extends EntityModel<DamselflyRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"damselfly_model"), "main");

    public DamselflyModel(ModelPart root) {
        super(root);
    }

    public void setupAnim(DamselflyRenderState state) {
        super.setupAnim((EntityRenderState)state);
        this.animate(state.flyAnimationState, DamselflyAnimation.FLY, state.ageInTicks, 10.0f);
        this.animate(state.perchAnimationState, DamselflyAnimation.PERCH, state.ageInTicks, 1.5f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 19).addBox(-2.0f, 0.0f, -6.0f, 3.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(18, 19).addBox(-1.5f, -1.0f, -6.0f, 2.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 8).addBox(-1.5f, 0.0f, -8.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 4).addBox(-2.75f, -0.5f, -8.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-0.25f, -0.5f, -8.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.5f, -0.5f, 0.0f, 2.0f, 2.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)22.0f, (float)-2.0f));
        PartDefinition wing_left_front = body.addOrReplaceChild("wing_left_front", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, 0.0f, -1.0f, 15.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)-4.75f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition wing_left_hind = body.addOrReplaceChild("wing_left_hind", CubeListBuilder.create().texOffs(13, 8).addBox(0.0f, 0.0f, -1.0f, 15.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-0.5f, (float)-2.25f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition wing_right_front = body.addOrReplaceChild("wing_right_front", CubeListBuilder.create().texOffs(13, 4).addBox(-15.0f, 0.0f, -1.0f, 15.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-1.0f, (float)-4.75f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition wing_right_hind = body.addOrReplaceChild("wing_right_hind", CubeListBuilder.create().texOffs(13, 0).addBox(-15.0f, 0.0f, -1.0f, 15.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-0.5f, (float)-2.25f, (float)0.0f, (float)0.1745f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

