/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.model;

import net.invictusslayer.slayersbeasts.client.animation.MantisAnimation;
import net.invictusslayer.slayersbeasts.client.state.MantisRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MantisModel
extends EntityModel<MantisRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"mantis_model"), "main");
    private final ModelPart head;

    public MantisModel(ModelPart root) {
        super(root);
        this.head = root.getChild("body").getChild("head");
    }

    public void setupAnim(MantisRenderState state) {
        super.setupAnim((EntityRenderState)state);
        this.head.xRot += Mth.clamp((float)state.xRot, (float)-22.5f, (float)22.5f) * (float)Math.PI / 180.0f;
        this.head.yRot += Mth.clamp((float)state.yRot, (float)-32.5f, (float)32.5f) * (float)Math.PI / 180.0f;
        this.animate(state.flapAnimationState, MantisAnimation.FLAP, state.ageInTicks, 10.0f);
        this.animate(state.strikeAnimationState, MantisAnimation.STRIKE, state.ageInTicks, 8.0f);
        if (state.isScuttling) {
            this.animateWalk(MantisAnimation.SCUTTLE, state.walkAnimationPos, state.walkAnimationSpeed, 10.0f, 10.0f);
        } else {
            this.animateWalk(MantisAnimation.WALK, state.walkAnimationPos, state.walkAnimationSpeed, 10.0f, 10.0f);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -1.0f, -17.0f, 5.0f, 3.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(100, 94).addBox(-3.5f, -1.0f, -4.0f, 7.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(102, 84).addBox(-4.5f, -2.0f, -5.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(88, 104).addBox(1.5f, -2.0f, -5.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 107).addBox(-2.5f, 5.0f, -3.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-16.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(76, 72).addBox(-0.5f, -9.5f, -12.0f, 0.0f, 9.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-0.5f, (float)-2.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(76, 72).addBox(0.5f, -9.5f, -12.0f, 0.0f, 9.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-0.5f, (float)-2.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition jaw_left = head.addOrReplaceChild("jaw_left", CubeListBuilder.create().texOffs(82, 31).addBox(0.0f, -1.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition jaw_right = head.addOrReplaceChild("jaw_right", CubeListBuilder.create().texOffs(82, 26).addBox(-4.0f, -1.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition abdomen = body.addOrReplaceChild("abdomen", CubeListBuilder.create().texOffs(0, 31).addBox(-5.0f, -4.0f, 0.0f, 10.0f, 5.0f, 21.0f, new CubeDeformation(0.0f)).texOffs(76, 94).addBox(-4.0f, -4.0f, 21.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)11.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition wing_left_upper = body.addOrReplaceChild("wing_left_upper", CubeListBuilder.create().texOffs(56, 102).addBox(-0.5f, -40.0f, -1.0f, 1.0f, 22.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(46, 102).addBox(-0.5f, -18.0f, -1.0f, 1.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 57).addBox(0.0f, -42.0f, -1.0f, 0.0f, 40.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)-2.0f, (float)-1.4399f, (float)0.3491f, (float)-1.2217f));
        PartDefinition wing_left_lower = body.addOrReplaceChild("wing_left_lower", CubeListBuilder.create().texOffs(40, 102).addBox(-1.0f, -24.0f, -1.0f, 1.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 57).addBox(-0.5f, -38.0f, -1.0f, 0.0f, 36.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)1.0f, (float)-1.4399f, (float)0.3491f, (float)-1.3526f));
        PartDefinition lw1 = wing_left_lower.addOrReplaceChild("lw1", CubeListBuilder.create().texOffs(66, 0).addBox(0.0f, -32.0f, 1.0f, 0.0f, 28.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition lw2 = lw1.addOrReplaceChild("lw2", CubeListBuilder.create().texOffs(82, 0).addBox(0.0f, -24.0f, 2.0f, 0.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)4.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leg_left_front = body.addOrReplaceChild("leg_left_front", CubeListBuilder.create().texOffs(102, 104).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)2.0f, (float)-9.0f, (float)0.3491f, (float)-0.3491f, (float)-0.3054f));
        PartDefinition l11 = leg_left_front.addOrReplaceChild("l11", CubeListBuilder.create().texOffs(92, 52).addBox(-0.999f, -1.0f, -11.0f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(102, 0).addBox(0.0f, 3.0f, -8.5f, 0.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)0.0f, (float)-1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition l12 = l11.addOrReplaceChild("l12", CubeListBuilder.create().texOffs(32, 107).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(70, 36).addBox(0.001f, 4.5f, 0.0f, 0.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(70, 109).addBox(-0.5f, 9.0f, -1.0f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-10.0f, (float)0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition leg_left_mid = body.addOrReplaceChild("leg_left_mid", CubeListBuilder.create().texOffs(16, 107).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(92, 68).addBox(1.001f, 6.0f, -1.0f, 9.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(102, 16).addBox(-0.999f, 8.0f, 0.0f, 9.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(62, 36).addBox(8.001f, 8.0f, -1.0f, 2.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)2.0f, (float)-2.0f, (float)0.3491f, (float)0.5236f, (float)-0.1309f));
        PartDefinition leg_left_hind = body.addOrReplaceChild("leg_left_hind", CubeListBuilder.create().texOffs(24, 107).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(102, 12).addBox(1.001f, 6.0f, -1.0f, 9.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(102, 72).addBox(-0.999f, 8.0f, 0.0f, 9.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(62, 102).addBox(8.001f, 8.0f, -1.0f, 2.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)2.0f, (float)2.0f, (float)0.6981f, (float)-0.2182f, (float)-0.6545f));
        PartDefinition wing_right_upper = body.addOrReplaceChild("wing_right_upper", CubeListBuilder.create().texOffs(56, 102).addBox(-0.5f, -40.0f, -1.0f, 1.0f, 22.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(46, 102).addBox(-0.5f, -18.0f, -1.0f, 1.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(20, 57).addBox(0.0f, -42.0f, -1.0f, 0.0f, 40.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)-2.0f, (float)-1.4399f, (float)-0.3491f, (float)1.2217f));
        PartDefinition wing_right_lower = body.addOrReplaceChild("wing_right_lower", CubeListBuilder.create().texOffs(40, 102).addBox(0.0f, -24.0f, -1.0f, 1.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(58, 57).addBox(0.5f, -38.0f, -1.0f, 0.0f, 36.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)1.0f, (float)-1.4399f, (float)-0.3491f, (float)1.3526f));
        PartDefinition rw1 = wing_right_lower.addOrReplaceChild("rw1", CubeListBuilder.create().texOffs(76, 36).addBox(-1.0f, -32.0f, 1.0f, 0.0f, 28.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition rw2 = rw1.addOrReplaceChild("rw2", CubeListBuilder.create().texOffs(92, 26).addBox(-1.0f, -24.0f, 2.0f, 0.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)4.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right_front = body.addOrReplaceChild("leg_right_front", CubeListBuilder.create().texOffs(102, 104).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)2.0f, (float)-9.0f, (float)0.3491f, (float)0.3491f, (float)0.3054f));
        PartDefinition r11 = leg_right_front.addOrReplaceChild("r11", CubeListBuilder.create().texOffs(92, 52).addBox(-1.001f, -1.0f, -11.0f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(102, 0).addBox(0.0f, 3.0f, -8.5f, 0.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)0.0f, (float)-1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition r12 = r11.addOrReplaceChild("r12", CubeListBuilder.create().texOffs(32, 107).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(70, 36).addBox(-0.001f, 4.5f, 0.0f, 0.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(70, 109).addBox(-0.5f, 9.0f, -1.0f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-10.0f, (float)0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right_mid = body.addOrReplaceChild("leg_right_mid", CubeListBuilder.create().texOffs(16, 107).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(92, 68).addBox(-9.999f, 6.0f, -1.0f, 9.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(70, 102).addBox(-7.999f, 8.0f, 0.0f, 9.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(62, 36).addBox(-9.999f, 8.0f, -1.0f, 2.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)2.0f, (float)-2.0f, (float)0.3491f, (float)-0.5236f, (float)0.1309f));
        PartDefinition leg_right_hind = body.addOrReplaceChild("leg_right_hind", CubeListBuilder.create().texOffs(24, 107).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(102, 12).addBox(-9.999f, 6.0f, -1.0f, 9.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(102, 78).addBox(-7.999f, 8.0f, 0.0f, 9.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(62, 102).addBox(-9.999f, 8.0f, -1.0f, 2.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)2.0f, (float)2.0f, (float)0.6981f, (float)0.2182f, (float)0.6545f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }
}

