/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.invictusslayer.slayersbeasts.client.model.AntQueenModel;
import net.invictusslayer.slayersbeasts.client.state.AntQueenRenderState;
import net.invictusslayer.slayersbeasts.world.entity.AbstractAnt;
import net.invictusslayer.slayersbeasts.world.entity.AntQueen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class AntQueenRenderer
extends MobRenderer<AntQueen, AntQueenRenderState, AntQueenModel> {
    private static final ResourceLocation WOOD = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/wood_queen.png");
    private static final ResourceLocation LEAFCUTTER = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/leafcutter_queen.png");
    private static final ResourceLocation MEADOW = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/meadow_queen.png");

    public AntQueenRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AntQueenModel(context.bakeLayer(AntQueenModel.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(AntQueenRenderState state, PoseStack poseStack) {
        float f = 1.5f;
        poseStack.scale(f, f, f);
    }

    public ResourceLocation getTextureLocation(AntQueenRenderState state) {
        return switch (state.variant) {
            default -> throw new MatchException(null, null);
            case AbstractAnt.Variant.WOOD -> WOOD;
            case AbstractAnt.Variant.LEAFCUTTER -> LEAFCUTTER;
            case AbstractAnt.Variant.MEADOW -> MEADOW;
        };
    }

    public AntQueenRenderState createRenderState() {
        return new AntQueenRenderState();
    }

    public void extractRenderState(AntQueen entity, AntQueenRenderState state, float f) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, f);
        state.variant = entity.getVariant();
    }
}

