/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.renderer;

import net.invictusslayer.slayersbeasts.client.model.DamselflyModel;
import net.invictusslayer.slayersbeasts.client.state.DamselflyRenderState;
import net.invictusslayer.slayersbeasts.world.entity.Damselfly;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class DamselflyRenderer
extends MobRenderer<Damselfly, DamselflyRenderState, DamselflyModel> {
    private static final ResourceLocation BLUE = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/damselfly/blue.png");
    private static final ResourceLocation GREEN = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/damselfly/green.png");
    private static final ResourceLocation YELLOW = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/damselfly/yellow.png");

    public DamselflyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new DamselflyModel(context.bakeLayer(DamselflyModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(DamselflyRenderState state) {
        return switch (state.variant) {
            default -> throw new MatchException(null, null);
            case Damselfly.Variant.BLUE -> BLUE;
            case Damselfly.Variant.GREEN -> GREEN;
            case Damselfly.Variant.YELLOW -> YELLOW;
        };
    }

    public DamselflyRenderState createRenderState() {
        return new DamselflyRenderState();
    }

    public void extractRenderState(Damselfly entity, DamselflyRenderState state, float f) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, f);
        state.variant = entity.getVariant();
        state.flyAnimationState.copyFrom(entity.flyAnimationState);
        state.perchAnimationState.copyFrom(entity.perchAnimationState);
    }
}

