/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.invictusslayer.slayersbeasts.client.model.EntMediumModel;
import net.invictusslayer.slayersbeasts.client.state.EntRenderState;
import net.invictusslayer.slayersbeasts.world.entity.AbstractEnt;
import net.invictusslayer.slayersbeasts.world.entity.EntMedium;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class EntMediumRenderer
extends MobRenderer<EntMedium, EntRenderState, EntMediumModel> {
    private static final ResourceLocation OAK = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ent/oak.png");
    private static final ResourceLocation BIRCH = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ent/birch.png");
    private static final ResourceLocation JUNGLE = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ent/jungle.png");

    public EntMediumRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new EntMediumModel(context.bakeLayer(EntMediumModel.LAYER_LOCATION)), 0.9f);
    }

    protected void scale(EntRenderState state, PoseStack poseStack) {
        float f = 1.2f;
        poseStack.scale(f, f, f);
    }

    public ResourceLocation getTextureLocation(EntRenderState state) {
        return switch (state.variant) {
            default -> throw new MatchException(null, null);
            case AbstractEnt.Variant.OAK -> OAK;
            case AbstractEnt.Variant.BIRCH -> BIRCH;
            case AbstractEnt.Variant.JUNGLE -> JUNGLE;
        };
    }

    public EntRenderState createRenderState() {
        return new EntRenderState();
    }

    public void extractRenderState(EntMedium entity, EntRenderState state, float f) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, f);
        state.variant = entity.getVariant();
    }
}

