/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.renderer;

import net.invictusslayer.slayersbeasts.client.model.WuduModel;
import net.invictusslayer.slayersbeasts.client.state.EntRenderState;
import net.invictusslayer.slayersbeasts.world.entity.AbstractEnt;
import net.invictusslayer.slayersbeasts.world.entity.Wudu;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class WuduRenderer
extends MobRenderer<Wudu, EntRenderState, WuduModel> {
    private static final ResourceLocation OAK = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ent/wudu/oak.png");
    private static final ResourceLocation BIRCH = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ent/wudu/birch.png");
    private static final ResourceLocation JUNGLE = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ent/wudu/jungle.png");

    public WuduRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new WuduModel(context.bakeLayer(WuduModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(EntRenderState state) {
        return switch (state.variant) {
            default -> throw new MatchException(null, null);
            case AbstractEnt.Variant.OAK -> OAK;
            case AbstractEnt.Variant.BIRCH -> BIRCH;
            case AbstractEnt.Variant.JUNGLE -> JUNGLE;
        };
    }

    public EntRenderState createRenderState() {
        return new EntRenderState();
    }

    public void extractRenderState(Wudu entity, EntRenderState state, float f) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, f);
        state.variant = entity.getVariant();
    }
}

