/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.invictusslayer.slayersbeasts.client.model.AntCargoModel;
import net.invictusslayer.slayersbeasts.client.model.AntWorkerModel;
import net.invictusslayer.slayersbeasts.client.state.AntWorkerRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class AntCargoLayer
extends RenderLayer<AntWorkerRenderState, AntWorkerModel> {
    private static final ResourceLocation LEAF = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/cargo/leaf.png");
    private static final ResourceLocation BARK = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/cargo/bark.png");
    private final AntCargoModel model;

    public AntCargoLayer(RenderLayerParent<AntWorkerRenderState, AntWorkerModel> parent, EntityModelSet set) {
        super(parent);
        this.model = new AntCargoModel(set.bakeLayer(AntCargoModel.LAYER_LOCATION));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, AntWorkerRenderState state, float netHeadYaw, float headPitch) {
        if (state.cargo == 99) {
            return;
        }
        if (state.isInvisible && state.appearsGlowing) {
            this.model.setupAnim(state);
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.outline((ResourceLocation)LEAF));
            this.model.renderToBuffer(poseStack, consumer, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
            return;
        }
        if (state.cargo == 1) {
            AntCargoLayer.renderColoredCutoutModel((EntityModel)this.model, (ResourceLocation)LEAF, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (LivingEntityRenderState)state, (int)-1);
        } else if (state.cargo == 2) {
            AntCargoLayer.renderColoredCutoutModel((EntityModel)this.model, (ResourceLocation)BARK, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (LivingEntityRenderState)state, (int)-1);
        }
    }
}

