/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data;

import java.util.Objects;
import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import net.invictusslayer.slayersbeasts.world.level.block.SBBlockFamily;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.core.Direction;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.Tilt;

public class SBModelProvider
extends ModelProvider {
    public SBModelProvider(PackOutput output) {
        super(output, "slayersbeasts");
    }

    protected void registerModels(BlockModelGenerators blockGen, ItemModelGenerators itemGen) {
        this.generateBlockFamilies(blockGen);
        this.generateWoodFamilies(blockGen, itemGen);
        blockGen.createTrivialCube(SBBlocks.CRYPT_PORTAL.get());
        blockGen.createRotatedMirroredVariantBlock(SBBlocks.CRYPTALITH.get());
        this.createInfusedCryptalith(blockGen, SBBlocks.INFUSED_CRYPTALITH.get(), SBBlocks.CRYPTALITH.get());
        this.createDepletedCryptalith(blockGen, SBBlocks.DEPLETED_CRYPTALITH.get(), SBBlocks.CRYPTALITH.get());
        blockGen.createTrivialCube(SBBlocks.JADE_BLOCK.get());
        blockGen.createTrivialCube(SBBlocks.EXOSKELETON_ORE.get());
        blockGen.createTrivialCube(SBBlocks.DEEPSLATE_EXOSKELETON_ORE.get());
        this.createStyphium(blockGen, SBBlocks.STYPHIUM.get());
        this.createStyphium(blockGen, SBBlocks.DEEPSLATE_STYPHIUM.get());
        blockGen.createRotatedVariantBlock(SBBlocks.RUDOSOL.get());
        blockGen.createRotatedVariantBlock(SBBlocks.ARIDISOL.get());
        blockGen.createTrivialBlock(SBBlocks.ANTHILL.get(), TexturedModel.COLUMN);
        blockGen.createTrivialBlock(SBBlocks.ANTHILL_HATCHERY.get(), TexturedModel.COLUMN);
        blockGen.createTrivialBlock(SBBlocks.OOTHECA.get(), TexturedModel.COLUMN);
        blockGen.createTrivialCube(SBBlocks.GLEAMING_ICE.get());
        this.createSpike(blockGen, SBBlocks.ICICLE.get(), "_frustum_down");
        this.createSpike(blockGen, SBBlocks.OBSIDIAN_SPIKE.get(), "_tip_up");
        this.createDoublePlantWithRenderType(blockGen, SBBlocks.TALL_DEAD_BUSH.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.createTiltingBlock(blockGen, SBBlocks.CRACKED_MUD.get());
        blockGen.createTrivialCube(SBBlocks.PEAT.get());
        this.createFloatingPlant(blockGen, SBBlocks.ALGAE.get());
        blockGen.createRotatedVariantBlock(SBBlocks.BLACK_SAND.get());
        TexturedModel blackSandstoneModel = TexturedModel.TOP_BOTTOM_WITH_WALL.get(SBBlocks.BLACK_SANDSTONE.get());
        BlockModelGenerators blockModelGenerators = blockGen;
        Objects.requireNonNull(blockModelGenerators);
        BlockModelGenerators.BlockFamilyProvider blackSandstone = new BlockModelGenerators.BlockFamilyProvider(blockModelGenerators, blackSandstoneModel.getMapping());
        blackSandstone.fullBlock(SBBlocks.BLACK_SANDSTONE.get(), blackSandstoneModel.getTemplate());
        blackSandstone.slab(SBBlocks.BLACK_SANDSTONE_SLAB.get());
        blackSandstone.stairs(SBBlocks.BLACK_SANDSTONE_STAIRS.get());
        blackSandstone.wall(SBBlocks.BLACK_SANDSTONE_WALL.get());
        TexturedModel smoothBlackSandstoneModel = TexturedModel.createAllSame((ResourceLocation)TextureMapping.getBlockTexture((Block)SBBlocks.BLACK_SANDSTONE.get(), (String)"_top"));
        BlockModelGenerators blockModelGenerators2 = blockGen;
        Objects.requireNonNull(blockModelGenerators2);
        BlockModelGenerators.BlockFamilyProvider smoothBlackSandstone = new BlockModelGenerators.BlockFamilyProvider(blockModelGenerators2, smoothBlackSandstoneModel.getMapping());
        smoothBlackSandstone.fullBlock(SBBlocks.SMOOTH_BLACK_SANDSTONE.get(), smoothBlackSandstoneModel.getTemplate()).generateFor(SBBlockFamily.SMOOTH_BLACK_SANDSTONE);
        TexturedModel cutBlackSandstoneModel = TexturedModel.COLUMN.get(SBBlocks.BLACK_SANDSTONE.get()).updateTextures(mapping -> mapping.put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)SBBlocks.CUT_BLACK_SANDSTONE.get())));
        BlockModelGenerators blockModelGenerators3 = blockGen;
        Objects.requireNonNull(blockModelGenerators3);
        BlockModelGenerators.BlockFamilyProvider cutBlackSandstone = new BlockModelGenerators.BlockFamilyProvider(blockModelGenerators3, cutBlackSandstoneModel.getMapping());
        cutBlackSandstone.fullBlock(SBBlocks.CUT_BLACK_SANDSTONE.get(), cutBlackSandstoneModel.getTemplate()).generateFor(SBBlockFamily.CUT_BLACK_SANDSTONE);
        blockGen.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)SBBlocks.CHISELED_BLACK_SANDSTONE.get(), (ResourceLocation)TexturedModel.COLUMN.get(SBBlocks.CHISELED_BLACK_SANDSTONE.get()).updateTextures(mapping -> {
            mapping.put(TextureSlot.END, TextureMapping.getBlockTexture((Block)SBBlocks.BLACK_SANDSTONE.get(), (String)"_top"));
            mapping.put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)SBBlocks.CHISELED_BLACK_SANDSTONE.get()));
        }).create(SBBlocks.CHISELED_BLACK_SANDSTONE.get(), blockGen.modelOutput)));
        this.createDoublePlantWithRenderType(blockGen, SBBlocks.TALL_BROWN_MUSHROOM.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.createDoublePlantWithRenderType(blockGen, SBBlocks.TALL_RED_MUSHROOM.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        blockGen.createMushroomBlock(SBBlocks.BLACK_MUSHROOM_BLOCK.get());
        this.createPlantWithRenderType(blockGen, SBBlocks.BLACK_MUSHROOM.get(), SBBlocks.POTTED_BLACK_MUSHROOM.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.createDoublePlantWithRenderType(blockGen, SBBlocks.TALL_BLACK_MUSHROOM.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        blockGen.createMushroomBlock(SBBlocks.WHITE_MUSHROOM_BLOCK.get());
        this.createPlantWithRenderType(blockGen, SBBlocks.WHITE_MUSHROOM.get(), SBBlocks.POTTED_WHITE_MUSHROOM.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.createDoublePlantWithRenderType(blockGen, SBBlocks.TALL_WHITE_MUSHROOM.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        blockGen.createTrivialCube(SBBlocks.ALBINO_REDWOOD_LEAVES.get());
        this.createPlantWithRenderType(blockGen, SBBlocks.ALBINO_REDWOOD_SAPLING.get(), SBBlocks.POTTED_ALBINO_REDWOOD_SAPLING.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.createGrowingPlantWithRenderType(blockGen, SBBlocks.WILLOW_BRANCH.get(), SBBlocks.WILLOW_BRANCH_PLANT.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        itemGen.generateFlatItem(SBItems.MUSIC_DISC_INKISH.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.JADE.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.JADE_SHARD.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.CRYSTALLINE_WING.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.CRYSTALLINE_CLAW.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.CRYSTALLINE_CARAPACE.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.INSECT_WING.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.INSECT_CLAW.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.INSECT_EYE.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.INSECT_LEG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.FRIED_INSECT_LEG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.WITHERBONE.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.TIED_LEATHER.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.TANNED_LEATHER.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.MUD_BALL.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.MANTIS_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.ANT_WORKER_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.ANT_SOLDIER_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.ANT_QUEEN_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.WITHER_SPIDER_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.TYRACHNID_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.DAMSELFLY_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.ENT_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.WUDU_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
        itemGen.generateFlatItem(SBItems.SPORETRAP_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
    }

    public void createInfusedCryptalith(BlockModelGenerators blockGen, Block block, Block bottom) {
        ResourceLocation active = ModelTemplates.CUBE_BOTTOM_TOP.createWithSuffix(block, "_active", new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)bottom)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)"_top_active")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)"_side")), blockGen.modelOutput);
        ResourceLocation inActive = ModelTemplates.CUBE_BOTTOM_TOP.create(block, new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)bottom)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)"_side")), blockGen.modelOutput);
        blockGen.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.ACTIVE, (ResourceLocation)active, (ResourceLocation)inActive)).with(BlockModelGenerators.createHorizontalFacingDispatch()));
    }

    public void createDepletedCryptalith(BlockModelGenerators blockGen, Block block, Block bottom) {
        TextureMapping mapping = new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)bottom)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)"_side"));
        blockGen.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)ModelTemplates.CUBE_BOTTOM_TOP.create(block, mapping, blockGen.modelOutput)).with(BlockModelGenerators.createHorizontalFacingDispatch()));
    }

    public void createStyphium(BlockModelGenerators blockGen, Block block) {
        TextureMapping mapping = new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)block, (String)"_bottom")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)"_side"));
        blockGen.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)ModelTemplates.CUBE_BOTTOM_TOP.create(block, mapping, blockGen.modelOutput)));
    }

    public void createTiltingBlock(BlockModelGenerators blockGen, Block block) {
        PropertyDispatch.C1 property = PropertyDispatch.property((Property)BlockStateProperties.TILT);
        for (Tilt tilt : Tilt.values()) {
            property.select((Comparable)tilt, this.createTiltingBlockVariant(blockGen, block, tilt));
        }
        blockGen.registerSimpleItemModel(block.asItem(), TextureMapping.getBlockTexture((Block)block).withSuffix("_unstable"));
        blockGen.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)property));
    }

    public Variant createTiltingBlockVariant(BlockModelGenerators blockGen, Block block, Tilt tilt) {
        String suffix = "_" + tilt.getSerializedName();
        TextureMapping mapping = TextureMapping.cube((ResourceLocation)TextureMapping.getBlockTexture((Block)block, (String)suffix));
        return Variant.variant().with(VariantProperties.MODEL, (Object)ModelTemplates.CUBE_ALL.createWithSuffix(block, suffix, mapping, blockGen.modelOutput));
    }

    public void createSpike(BlockModelGenerators blockGen, Block block, String suffix) {
        PropertyDispatch.C2 properties = PropertyDispatch.properties((Property)BlockStateProperties.VERTICAL_DIRECTION, (Property)BlockStateProperties.DRIPSTONE_THICKNESS);
        for (DripstoneThickness thickness : DripstoneThickness.values()) {
            properties.select((Comparable)Direction.UP, (Comparable)thickness, this.createSpikeVariant(blockGen, block, Direction.UP, thickness));
        }
        for (DripstoneThickness thickness : DripstoneThickness.values()) {
            properties.select((Comparable)Direction.DOWN, (Comparable)thickness, this.createSpikeVariant(blockGen, block, Direction.DOWN, thickness));
        }
        blockGen.registerSimpleFlatItemModel(block, suffix);
        blockGen.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)properties));
    }

    public Variant createSpikeVariant(BlockModelGenerators blockGen, Block block, Direction direction, DripstoneThickness thickness) {
        String suffix = "_" + thickness.getSerializedName() + "_" + direction.getSerializedName();
        TextureMapping mapping = TextureMapping.cross((ResourceLocation)TextureMapping.getBlockTexture((Block)block, (String)suffix));
        return Variant.variant().with(VariantProperties.MODEL, (Object)ModelTemplates.POINTED_DRIPSTONE.extend().renderType("minecraft:cutout").build().createWithSuffix(block, suffix, mapping, blockGen.modelOutput));
    }

    public void createFloatingPlant(BlockModelGenerators blockGen, Block block) {
        blockGen.registerSimpleFlatItemModel(block);
        blockGen.blockStateOutput.accept(BlockModelGenerators.createRotatedVariant((Block)block, (ResourceLocation)ModelLocationUtils.getModelLocation((Block)block)));
    }

    public void createPlantWithRenderType(BlockModelGenerators blockGen, Block plant, Block potted, BlockModelGenerators.PlantType type) {
        blockGen.registerSimpleItemModel(plant.asItem(), type.createItemModel(blockGen, plant));
        blockGen.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)plant, (ResourceLocation)this.cutoutModel(blockGen, plant, type.getTextureMapping(plant), type.getCross())));
        blockGen.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)potted, (ResourceLocation)this.cutoutModel(blockGen, potted, type.getPlantTextureMapping(plant), type.getCrossPot())));
    }

    public void createDoublePlantWithRenderType(BlockModelGenerators blockGen, Block plant, BlockModelGenerators.PlantType type) {
        blockGen.registerSimpleFlatItemModel(plant, "_top");
        blockGen.createDoubleBlock(plant, blockGen.createSuffixedVariant(plant, "_top", (ModelTemplate)type.getCross().extend().renderType("minecraft:cutout").build(), TextureMapping::cross), blockGen.createSuffixedVariant(plant, "_bottom", (ModelTemplate)type.getCross().extend().renderType("minecraft:cutout").build(), TextureMapping::cross));
    }

    public void createGrowingPlantWithRenderType(BlockModelGenerators blockGen, Block plantEnd, Block plant, BlockModelGenerators.PlantType type) {
        blockGen.registerSimpleFlatItemModel(plantEnd);
        blockGen.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)plantEnd, (ResourceLocation)this.cutoutModel(blockGen, plantEnd, type.getTextureMapping(plantEnd), type.getCross())));
        blockGen.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)plant, (ResourceLocation)this.cutoutModel(blockGen, plant, type.getTextureMapping(plant), type.getCross())));
    }

    private void generateWoodFamilies(BlockModelGenerators blockGen, ItemModelGenerators itemGen) {
        SBWoodFamily.getAllFamilies().forEach(family -> {
            BlockModelGenerators.BlockFamilyProvider planks = blockGen.family((Block)family.get(WoodFamily.Variant.PLANKS).get());
            BlockModelGenerators.WoodProvider wood = blockGen.woodProvider((Block)family.get(WoodFamily.Variant.LOG).get());
            BlockModelGenerators.WoodProvider stripped = blockGen.woodProvider((Block)family.get(WoodFamily.Variant.STRIPPED_LOG).get());
            family.getVariants().forEach((variant, supplier) -> {
                if (supplier.get() == null) {
                    return;
                }
                switch (variant) {
                    case BOAT_ITEM: 
                    case CHEST_BOAT_ITEM: {
                        itemGen.generateFlatItem((Item)supplier.get(), ModelTemplates.FLAT_ITEM);
                        break;
                    }
                    case BUTTON: {
                        planks.button((Block)supplier.get());
                        break;
                    }
                    case DOOR: {
                        Block door = (Block)supplier.get();
                        TextureMapping mapping = TextureMapping.door((Block)door);
                        blockGen.blockStateOutput.accept(BlockModelGenerators.createDoor((Block)door, (ResourceLocation)this.cutoutModel(blockGen, door, mapping, ModelTemplates.DOOR_BOTTOM_LEFT), (ResourceLocation)this.cutoutModel(blockGen, door, mapping, ModelTemplates.DOOR_BOTTOM_LEFT_OPEN), (ResourceLocation)this.cutoutModel(blockGen, door, mapping, ModelTemplates.DOOR_BOTTOM_RIGHT), (ResourceLocation)this.cutoutModel(blockGen, door, mapping, ModelTemplates.DOOR_BOTTOM_RIGHT_OPEN), (ResourceLocation)this.cutoutModel(blockGen, door, mapping, ModelTemplates.DOOR_TOP_LEFT), (ResourceLocation)this.cutoutModel(blockGen, door, mapping, ModelTemplates.DOOR_TOP_LEFT_OPEN), (ResourceLocation)this.cutoutModel(blockGen, door, mapping, ModelTemplates.DOOR_TOP_RIGHT), (ResourceLocation)this.cutoutModel(blockGen, door, mapping, ModelTemplates.DOOR_TOP_RIGHT_OPEN)));
                        blockGen.registerSimpleFlatItemModel(((Block)supplier.get()).asItem());
                        break;
                    }
                    case FENCE: {
                        planks.fence((Block)supplier.get());
                        break;
                    }
                    case FENCE_GATE: {
                        planks.fenceGate((Block)supplier.get());
                        break;
                    }
                    case HANGING_SIGN: {
                        blockGen.createHangingSign((Block)family.get(WoodFamily.Variant.STRIPPED_LOG).get(), (Block)supplier.get(), (Block)family.get(WoodFamily.Variant.WALL_HANGING_SIGN).get());
                        break;
                    }
                    case LEAVES: {
                        blockGen.createTrivialCube((Block)supplier.get());
                        break;
                    }
                    case LOG: {
                        wood.log((Block)supplier.get());
                        break;
                    }
                    case SAPLING: {
                        this.createPlantWithRenderType(blockGen, (Block)supplier.get(), (Block)family.get(WoodFamily.Variant.POTTED_SAPLING).get(), BlockModelGenerators.PlantType.NOT_TINTED);
                        break;
                    }
                    case SIGN: {
                        ResourceLocation location = ModelTemplates.PARTICLE_ONLY.create((Block)supplier.get(), TexturedModel.CUBE.get((Block)family.get(WoodFamily.Variant.PLANKS).get()).getMapping(), blockGen.modelOutput);
                        blockGen.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)supplier.get()), (ResourceLocation)location));
                        blockGen.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)family.get(WoodFamily.Variant.WALL_SIGN).get()), (ResourceLocation)location));
                        blockGen.registerSimpleFlatItemModel(((Block)supplier.get()).asItem());
                        break;
                    }
                    case SLAB: {
                        planks.slab((Block)supplier.get());
                        break;
                    }
                    case STAIRS: {
                        planks.stairs((Block)supplier.get());
                        break;
                    }
                    case STRIPPED_LOG: {
                        stripped.log((Block)supplier.get());
                        break;
                    }
                    case STRIPPED_WOOD: {
                        stripped.wood((Block)supplier.get());
                        break;
                    }
                    case PRESSURE_PLATE: {
                        planks.pressurePlate((Block)supplier.get());
                        break;
                    }
                    case TRAPDOOR: {
                        Block trapdoor = (Block)supplier.get();
                        TextureMapping mapping = TextureMapping.defaultTexture((Block)trapdoor);
                        ResourceLocation bottom = this.cutoutModel(blockGen, trapdoor, mapping, ModelTemplates.ORIENTABLE_TRAPDOOR_BOTTOM);
                        blockGen.blockStateOutput.accept(BlockModelGenerators.createOrientableTrapdoor((Block)trapdoor, (ResourceLocation)this.cutoutModel(blockGen, trapdoor, mapping, ModelTemplates.ORIENTABLE_TRAPDOOR_TOP), (ResourceLocation)bottom, (ResourceLocation)this.cutoutModel(blockGen, trapdoor, mapping, ModelTemplates.ORIENTABLE_TRAPDOOR_OPEN)));
                        blockGen.registerSimpleItemModel(trapdoor, bottom);
                        break;
                    }
                    case WOOD: {
                        wood.wood((Block)supplier.get());
                    }
                }
            });
        });
    }

    private void generateBlockFamilies(BlockModelGenerators blockGen) {
        SBBlockFamily.getAllFamilies().filter(BlockFamily::shouldGenerateModel).forEach(family -> blockGen.family(family.getBaseBlock()).generateFor(family));
    }

    private ResourceLocation cutoutModel(BlockModelGenerators blockGen, Block block, TextureMapping mapping, ModelTemplate template) {
        return template.extend().renderType("minecraft:cutout").build().create(block, mapping, blockGen.modelOutput);
    }
}

