/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data.loot;

import java.util.Set;
import java.util.function.BiConsumer;
import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import net.invictusslayer.slayersbeasts.world.level.block.SBBlockFamily;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class SBBlockLoot
extends BlockLootSubProvider {
    public SBBlockLoot(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    public void generate() {
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
        this.generateBlockFamilies();
        this.dropSelf(SBBlocks.CRYPTALITH.get());
        this.dropOther(SBBlocks.INFUSED_CRYPTALITH.get(), (ItemLike)SBBlocks.DEPLETED_CRYPTALITH.get());
        this.dropSelf(SBBlocks.DEPLETED_CRYPTALITH.get());
        this.dropSelf(SBBlocks.JADE_BLOCK.get());
        this.add(SBBlocks.EXOSKELETON_ORE.get(), block -> this.createExoskeletonOreDrops(SBBlocks.EXOSKELETON_ORE.get()));
        this.add(SBBlocks.DEEPSLATE_EXOSKELETON_ORE.get(), block -> this.createExoskeletonOreDrops(SBBlocks.DEEPSLATE_EXOSKELETON_ORE.get()));
        this.add(SBBlocks.STYPHIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLESTONE));
        this.add(SBBlocks.DEEPSLATE_STYPHIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLED_DEEPSLATE));
        this.dropSelf(SBBlocks.RUDOSOL.get());
        this.dropSelf(SBBlocks.ARIDISOL.get());
        this.dropOther(SBBlocks.ANTHILL.get(), (ItemLike)SBBlocks.ARIDISOL.get());
        this.dropOther(SBBlocks.ANTHILL_HATCHERY.get(), (ItemLike)SBBlocks.ARIDISOL.get());
        this.dropWhenSilkTouch(SBBlocks.GLEAMING_ICE.get());
        this.dropWhenSilkTouch(SBBlocks.ICICLE.get());
        this.dropSelf(SBBlocks.OBSIDIAN_SPIKE.get());
        this.add(SBBlocks.TALL_DEAD_BUSH.get(), this::createTallDeadBushDrops);
        this.add(SBBlocks.CRACKED_MUD.get(), block -> this.createSingleItemTableWithSilkTouch(Blocks.PACKED_MUD, (ItemLike)SBItems.MUD_BALL.get(), (NumberProvider)ConstantValue.exactly((float)4.0f)));
        this.dropSelf(SBBlocks.PEAT.get());
        this.add(SBBlocks.ALGAE.get(), x$0 -> this.createShearsOnlyDrop((ItemLike)x$0));
        this.dropSelf(SBBlocks.BLACK_SAND.get());
        this.add(SBBlocks.TALL_BROWN_MUSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(SBBlocks.TALL_RED_MUSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(SBBlocks.BLACK_MUSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop(SBBlocks.BLACK_MUSHROOM_BLOCK.get(), (ItemLike)SBBlocks.BLACK_MUSHROOM.get()));
        this.dropSelf(SBBlocks.BLACK_MUSHROOM.get());
        this.dropPottedContents(SBBlocks.POTTED_BLACK_MUSHROOM.get());
        this.add(SBBlocks.TALL_BLACK_MUSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(SBBlocks.WHITE_MUSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop(SBBlocks.WHITE_MUSHROOM_BLOCK.get(), (ItemLike)SBBlocks.WHITE_MUSHROOM.get()));
        this.dropSelf(SBBlocks.WHITE_MUSHROOM.get());
        this.dropPottedContents(SBBlocks.POTTED_WHITE_MUSHROOM.get());
        this.add(SBBlocks.TALL_WHITE_MUSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.generateWoodFamilies();
        this.add(SBBlocks.ALBINO_REDWOOD_LEAVES.get(), block -> this.createLeavesDrops((Block)block, SBBlocks.ALBINO_REDWOOD_SAPLING.get(), new float[]{0.01f}));
        this.dropSelf(SBBlocks.ALBINO_REDWOOD_SAPLING.get());
        this.dropPottedContents(SBBlocks.POTTED_ALBINO_REDWOOD_SAPLING.get());
        this.add(SBBlocks.WILLOW_BRANCH.get(), block -> this.createLeavesDrops((Block)block, SBBlocks.WILLOW_SAPLING.get(), new float[]{0.03f}));
        this.add(SBBlocks.WILLOW_BRANCH_PLANT.get(), block -> this.createLeavesDrops((Block)block, SBBlocks.WILLOW_SAPLING.get(), new float[]{0.03f}));
    }

    private void generateWoodFamilies() {
        SBWoodFamily.getAllFamilies().forEach(family -> family.getVariants().forEach((variant, supplier) -> {
            Object patt0$temp = supplier.get();
            if (!(patt0$temp instanceof Block)) {
                return;
            }
            Block block = (Block)patt0$temp;
            switch (variant) {
                case DOOR: {
                    this.add(block, x$0 -> this.createDoorTable((Block)x$0));
                    break;
                }
                case LEAVES: {
                    this.add(block, this.createLeavesDrops(block, (Block)family.get(WoodFamily.Variant.SAPLING).get(), new float[]{0.05f}));
                    break;
                }
                case POTTED_SAPLING: {
                    this.dropPottedContents(block);
                    break;
                }
                case SLAB: {
                    this.add(block, x$0 -> this.createSlabItemTable((Block)x$0));
                    break;
                }
                case WALL_HANGING_SIGN: {
                    this.dropOther(block, (ItemLike)((Block)family.get(WoodFamily.Variant.HANGING_SIGN).get()));
                    break;
                }
                case WALL_SIGN: {
                    this.dropOther(block, (ItemLike)((Block)family.get(WoodFamily.Variant.SIGN).get()));
                    break;
                }
                default: {
                    this.dropSelf(block);
                }
            }
        }));
    }

    private void generateBlockFamilies() {
        SBBlockFamily.getAllFamilies().forEach(family -> {
            this.dropSelf(family.getBaseBlock());
            family.getVariants().forEach((variant, block) -> {
                switch (variant) {
                    case SLAB: {
                        this.add((Block)block, x$0 -> this.createSlabItemTable((Block)x$0));
                        break;
                    }
                    case DOOR: {
                        this.add((Block)block, x$0 -> this.createDoorTable((Block)x$0));
                        break;
                    }
                    case WALL_SIGN: {
                        this.dropOther((Block)block, (ItemLike)family.get(BlockFamily.Variant.SIGN));
                        break;
                    }
                    default: {
                        this.dropSelf((Block)block);
                    }
                }
            });
        });
    }

    private LootTable.Builder createTallDeadBushDrops(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasShears())).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)))).when(LootItemEntityPropertyCondition.entityPresent((LootContext.EntityTarget)LootContext.EntityTarget.THIS))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))))));
    }

    private LootTable.Builder createExoskeletonOreDrops(Block block) {
        HolderLookup.RegistryLookup registryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)SBItems.CRYSTALLINE_CLAW.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)))));
    }
}

