/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.entity;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Tyrachnid
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_RESTING = SynchedEntityData.defineId(Tyrachnid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Tyrachnid(EntityType<Tyrachnid> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.35f).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.MAX_HEALTH, 150.0).add(Attributes.ATTACK_DAMAGE, 15.0).add(Attributes.ATTACK_SPEED, 5.0).add(Attributes.ATTACK_KNOCKBACK, 3.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_RESTING, (Object)true);
    }

    public boolean isResting() {
        return (Boolean)this.entityData.get(DATA_IS_RESTING);
    }

    public void setResting(Boolean resting) {
        this.entityData.set(DATA_IS_RESTING, (Object)resting);
    }

    public TarantulaPose getTarantulaPose() {
        if (this.isResting()) {
            return TarantulaPose.RESTING;
        }
        if (this.isAggressive()) {
            return TarantulaPose.HOSTILE;
        }
        return TarantulaPose.PASSIVE;
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
    }

    public static enum TarantulaPose {
        RESTING,
        PASSIVE,
        HOSTILE,
        CHARGING_SHOT,
        CHARGING_LARGE_SHOT;

    }
}

