/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class BigMushroomFeature
extends Feature<Configuration> {
    public BigMushroomFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        BlockState stem;
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        Configuration config = (Configuration)context.config();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int height = config.height.sample(random);
        if (!this.isValidPosition((LevelAccessor)level, origin, mutableBlockPos, height)) {
            return false;
        }
        BlockState cap = config.capProvider.getState(random, origin);
        if (cap.hasProperty((Property)HugeMushroomBlock.DOWN)) {
            cap = (BlockState)cap.setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false));
        }
        if ((stem = config.stemProvider.getState(random, origin)).hasProperty((Property)HugeMushroomBlock.DOWN)) {
            stem = (BlockState)((BlockState)stem.setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(false));
        }
        mutableBlockPos.set((Vec3i)origin);
        for (int y = 0; y <= height - 1; ++y) {
            this.checkAndSetBlock(level, (BlockPos)mutableBlockPos, stem);
            mutableBlockPos.move(Direction.UP);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x * z == 0) {
                    this.checkAndSetBlock(level, (BlockPos)mutableBlockPos.setWithOffset((Vec3i)origin, x, height, z), cap);
                }
                this.checkAndSetBlock(level, (BlockPos)mutableBlockPos.setWithOffset((Vec3i)origin, x, height - 1, z), cap);
            }
        }
        return true;
    }

    private void checkAndSetBlock(WorldGenLevel level, BlockPos pos, BlockState state) {
        if (!level.getBlockState(pos).isSolidRender()) {
            this.setBlock((LevelWriter)level, pos, state);
        }
    }

    private boolean isValidPosition(LevelAccessor level, BlockPos pos, BlockPos.MutableBlockPos mutableBlockPos, int height) {
        int i = pos.getY();
        if (i >= level.getMinY() + 1 && i + height + 1 < level.getMaxY()) {
            BlockState below = level.getBlockState(pos.below());
            if (!BigMushroomFeature.isDirt((BlockState)below) && !below.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
                return false;
            }
            for (int y = 0; y <= height; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockState state = level.getBlockState((BlockPos)mutableBlockPos.setWithOffset((Vec3i)pos, x, y, z));
                        if (state.isAir() || state.is(BlockTags.LEAVES)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public record Configuration(IntProvider height, BlockStateProvider capProvider, BlockStateProvider stemProvider) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.CODEC.fieldOf("height").forGetter(Configuration::height), (App)BlockStateProvider.CODEC.fieldOf("cap_provider").forGetter(Configuration::capProvider), (App)BlockStateProvider.CODEC.fieldOf("stem_provider").forGetter(Configuration::stemProvider)).apply((Applicative)instance, Configuration::new));
    }
}

