/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class BranchingMushroomFeature
extends Feature<Configuration> {
    private final boolean[] branchChecks = new boolean[5];

    public BranchingMushroomFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        BlockPos.MutableBlockPos mutableBlockPos;
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        Configuration config = (Configuration)context.config();
        int height = config.height.sample(random);
        if (!this.isValidPosition((LevelAccessor)level, origin, height, mutableBlockPos = new BlockPos.MutableBlockPos(), config)) {
            return false;
        }
        List<CapAttachment> attachments = this.placeStem((LevelAccessor)level, random, origin, config, height, mutableBlockPos);
        attachments.forEach(attachment -> this.placeCap((LevelAccessor)level, random, attachment.origin, config, mutableBlockPos, attachment.variant));
        return true;
    }

    private void placeCap(LevelAccessor level, RandomSource random, BlockPos pos, Configuration config, BlockPos.MutableBlockPos mutableBlockPos, int variant) {
        BlockState state = (BlockState)config.capProvider.getState(random, pos).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(variant < 2));
        this.setBlock((LevelWriter)level, pos, state);
        if (variant < 2) {
            this.setBlock((LevelWriter)level, pos.above(), state);
        }
        Direction.Plane.HORIZONTAL.forEach(direction -> {
            if (variant == 1) {
                this.setBlock((LevelWriter)level, pos.relative(direction).below(), state);
            }
            if (variant == 3) {
                this.setBlock((LevelWriter)level, pos.relative(direction).relative(direction.getClockWise()), state);
            }
            if (variant < 4) {
                this.setBlock((LevelWriter)level, pos.relative(direction), state);
            }
        });
    }

    private List<CapAttachment> placeStem(LevelAccessor level, RandomSource random, BlockPos pos, Configuration config, int maxHeight, BlockPos.MutableBlockPos mutableBlockPos) {
        Direction direction;
        int i;
        BlockState state = config.stemProvider.getState(random, pos);
        ArrayList<CapAttachment> attachments = new ArrayList<CapAttachment>();
        Arrays.fill(this.branchChecks, true);
        int height = 3 + random.nextInt(3);
        int max = 0;
        ArrayList<Direction> directions = new ArrayList<Direction>(List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST));
        for (i = 0; i < random.nextInt(3); ++i) {
            direction = (Direction)directions.remove(0);
            directions.add(direction);
        }
        for (i = 0; i < 2 + random.nextInt(3); ++i) {
            direction = (Direction)directions.get(i);
            int h = height - random.nextInt(3);
            attachments.add(this.placeBranch(level, random, pos.above(h), state, config, maxHeight - h, mutableBlockPos, direction, i));
            max = Math.max(max, h);
        }
        this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos.set((Vec3i)pos), state);
        for (i = 0; i < max; ++i) {
            this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos.move(Direction.UP), state);
        }
        return attachments;
    }

    private CapAttachment placeBranch(LevelAccessor level, RandomSource random, BlockPos pos, BlockState state, Configuration config, int maxHeight, BlockPos.MutableBlockPos mutableBlockPos, Direction direction, int j) {
        boolean flag = false;
        int height = random.nextInt(maxHeight);
        mutableBlockPos.set((Vec3i)pos);
        this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos.move(direction), state);
        if (this.branchChecks[0] && random.nextInt(6 - j) == 0) {
            flag = true;
        } else {
            this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos.move(direction), state);
        }
        if (random.nextInt(5 - j) == 0) {
            if (random.nextBoolean()) {
                if (this.branchChecks[this.check(j, true)]) {
                    this.branchChecks[this.check((int)j, (boolean)true)] = false;
                    this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos.move(direction.getClockWise()), state);
                    if (flag) {
                        if (random.nextBoolean()) {
                            this.branchChecks[0] = false;
                        } else {
                            this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos.move(direction.getClockWise()), state);
                        }
                    }
                }
            } else if (this.branchChecks[this.check(j, false)]) {
                this.branchChecks[this.check((int)j, (boolean)false)] = false;
                this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos.move(direction.getCounterClockWise()), state);
                if (flag) {
                    if (random.nextBoolean()) {
                        this.branchChecks[0] = false;
                    } else {
                        this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos.move(direction.getCounterClockWise()), state);
                    }
                }
            }
        } else if (flag) {
            this.branchChecks[0] = false;
        }
        flag = true;
        for (int i = 0; i < height; ++i) {
            this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos.move(Direction.UP), state);
            if (!flag || !(random.nextFloat() > 0.75f) || i <= 1 || i >= height - 2) continue;
            flag = false;
            Direction dir = List.of(direction, direction.getClockWise(), direction.getCounterClockWise()).get(random.nextInt(3));
            this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos.move(dir), state);
        }
        return new CapAttachment(mutableBlockPos.above(), height < 2 ? 4 : random.nextInt(4));
    }

    private int check(int i, boolean clockwise) {
        return clockwise ? i + 1 : (i == 0 ? 4 : i);
    }

    private boolean isValidPosition(LevelAccessor level, BlockPos origin, int maxHeight, BlockPos.MutableBlockPos mutableBlockPos, Configuration config) {
        if (origin.getY() <= level.getMinY() || origin.getY() + maxHeight > level.getMaxY()) {
            return false;
        }
        BlockState state = level.getBlockState(origin.below());
        if (!BranchingMushroomFeature.isDirt((BlockState)state) && !state.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
            return false;
        }
        for (int y = 0; y <= maxHeight; ++y) {
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    BlockState blockState = level.getBlockState((BlockPos)mutableBlockPos.setWithOffset((Vec3i)origin, x, y, z));
                    if (blockState.isAir() || blockState.is(BlockTags.LEAVES)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public record Configuration(IntProvider height, BlockStateProvider capProvider, BlockStateProvider stemProvider) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.CODEC.fieldOf("height").forGetter(Configuration::height), (App)BlockStateProvider.CODEC.fieldOf("cap_provider").forGetter(Configuration::capProvider), (App)BlockStateProvider.CODEC.fieldOf("stem_provider").forGetter(Configuration::stemProvider)).apply((Applicative)instance, Configuration::new));
    }

    public record CapAttachment(BlockPos origin, int variant) {
    }
}

