/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom.AbstractMightyMushroomFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public class MightyBrownMushroomFeature
extends AbstractMightyMushroomFeature {
    public MightyBrownMushroomFeature(Codec<HugeMushroomFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    protected void placeCap(LevelAccessor level, RandomSource random, BlockPos pos, HugeMushroomFeatureConfiguration config, int height, BlockPos.MutableBlockPos mutableBlockPos) {
        for (int y = height - 2; y <= height; ++y) {
            int stage = height - y;
            int radius = stage == 1 ? 4 : 3;
            for (int x = -radius; x <= radius + 1; ++x) {
                for (int z = -radius; z <= radius + 1; ++z) {
                    if (!MightyBrownMushroomFeature.isBlock(x, z, stage)) continue;
                    mutableBlockPos.setWithOffset((Vec3i)pos, x, y, z);
                    if (level.getBlockState((BlockPos)mutableBlockPos).isSolidRender()) continue;
                    boolean flag = stage < 2;
                    boolean north = flag && z <= 0;
                    boolean south = flag && z >= 0;
                    boolean east = flag && x >= 0;
                    boolean west = flag && x <= 0;
                    BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.capProvider.getState(random, pos).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(south));
                    this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos, state);
                }
            }
        }
    }

    private static boolean isBlock(int x, int z, int stage) {
        int xRad = Math.min(Math.abs(x), Math.abs(x - 1));
        int zRad = Math.min(Math.abs(z), Math.abs(z - 1));
        int sum = xRad + zRad;
        if (stage == 0) {
            return sum < 4 || xRad == 2 && zRad == 2;
        }
        if (stage == 1) {
            return sum < 5 || xRad * zRad == 6;
        }
        if (stage == 2) {
            return sum < 3;
        }
        return false;
    }

    @Override
    protected int getTreeRadiusForHeight(int radius, int height) {
        return height < 3 ? radius : 0;
    }
}

