/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.invictusslayer.slayersbeasts.registries.SBTreeDecorators;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class HangingBranchDecorator
extends TreeDecorator {
    public static final MapCodec<HangingBranchDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)BlockStateProvider.CODEC.fieldOf("head_provider").forGetter(decorator -> decorator.headProvider), (App)BlockStateProvider.CODEC.fieldOf("body_provider").forGetter(decorator -> decorator.bodyProvider)).apply((Applicative)instance, HangingBranchDecorator::new));
    private final float probability;
    private final BlockStateProvider headProvider;
    private final BlockStateProvider bodyProvider;

    public HangingBranchDecorator(float probability, BlockStateProvider headProvider, BlockStateProvider bodyProvider) {
        this.probability = probability;
        this.headProvider = headProvider;
        this.bodyProvider = bodyProvider;
    }

    protected TreeDecoratorType<?> type() {
        return SBTreeDecorators.HANGING_BRANCH.get();
    }

    public void place(TreeDecorator.Context pContext) {
        for (BlockPos leafPos : Util.shuffledCopy((ObjectArrayList)pContext.leaves(), (RandomSource)pContext.random())) {
            BlockPos branchPos = leafPos.relative(Direction.DOWN);
            int height = pContext.random().nextInt(1, 6);
            if (!pContext.isAir(branchPos) || !(pContext.random().nextFloat() < this.probability)) continue;
            this.placeBranchColumn(pContext, branchPos, height);
        }
    }

    private void placeBranchColumn(TreeDecorator.Context pContext, BlockPos pPos, int pHeight) {
        for (int i = 0; i < pHeight; ++i) {
            BlockPos blockPos = pPos.relative(Direction.DOWN, i);
            if (!pContext.isAir(blockPos.below())) {
                pContext.setBlock(blockPos, this.headProvider.getState(pContext.random(), blockPos));
                break;
            }
            pContext.setBlock(blockPos, this.bodyProvider.getState(pContext.random(), blockPos));
        }
    }
}

