/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.structure.pieces;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class CryptPieces {
    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, Holder<StructureTemplatePool> start, BlockPos pos, int maxDistanceFromCenter, PoolAliasLookup lookup, LiquidSettings liquidSettings) {
        RegistryAccess access = context.registryAccess();
        ChunkGenerator chunkGen = context.chunkGenerator();
        StructureTemplateManager manager = context.structureTemplateManager();
        LevelHeightAccessor heightAccessor = context.heightAccessor();
        WorldgenRandom random = context.random();
        Registry registry = access.lookupOrThrow(Registries.TEMPLATE_POOL);
        StructureTemplatePool pool = (StructureTemplatePool)start.value();
        StructurePoolElement element = pool.getRandomTemplate((RandomSource)random);
        BlockPos vec3i = pos.subtract((Vec3i)pos);
        BlockPos blockPos = pos.subtract((Vec3i)vec3i);
        PoolElementStructurePiece piece = new PoolElementStructurePiece(manager, element, blockPos, element.getGroundLevelDelta(), Rotation.NONE, element.getBoundingBox(manager, blockPos, Rotation.NONE), LiquidSettings.IGNORE_WATERLOGGING);
        BoundingBox box = piece.getBoundingBox();
        int x = (box.maxX() + box.minX()) / 2;
        int z = (box.maxZ() + box.minZ()) / 2;
        int y = vec3i.getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos(x, y, z), builder -> {
            ArrayList list = Lists.newArrayList();
            list.add(piece);
            AABB aabb = new AABB((double)(x - maxDistanceFromCenter), (double)(y - maxDistanceFromCenter), (double)(z - maxDistanceFromCenter), (double)(x + maxDistanceFromCenter + 1), (double)(y + maxDistanceFromCenter + 1), (double)(z + maxDistanceFromCenter + 1));
            VoxelShape shape = Shapes.join((VoxelShape)Shapes.create((AABB)aabb), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)box)), (BooleanOp)BooleanOp.ONLY_FIRST);
            CryptPieces.addPieces(context.randomState(), 7, false, chunkGen, manager, heightAccessor, (RandomSource)random, (Registry<StructureTemplatePool>)registry, piece, list, shape, lookup, liquidSettings);
            list.forEach(arg_0 -> ((StructurePiecesBuilder)builder).addPiece(arg_0));
        }));
    }

    private static void addPieces(RandomState randomState, int maxDepth, boolean useExpansionHack, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, LevelHeightAccessor level, RandomSource random, Registry<StructureTemplatePool> pools, PoolElementStructurePiece startPiece, List<PoolElementStructurePiece> pieces, VoxelShape free, PoolAliasLookup aliasLookup, LiquidSettings liquidSettings) {
        Placer placer = new Placer(pools, maxDepth, chunkGenerator, structureTemplateManager, pieces, random);
        placer.tryPlacingChildren(startPiece, (MutableObject<VoxelShape>)new MutableObject((Object)free), 0, useExpansionHack, level, randomState, aliasLookup, liquidSettings);
        while (placer.placing.hasNext()) {
            PieceState pieceState = (PieceState)placer.placing.next();
            placer.tryPlacingChildren(pieceState.piece, pieceState.free, pieceState.depth, useExpansionHack, level, randomState, aliasLookup, liquidSettings);
        }
    }

    private static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGen;
        private final StructureTemplateManager manager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final SequencedPriorityIterator<PieceState> placing = new SequencedPriorityIterator();

        Placer(Registry<StructureTemplatePool> pools, int maxDepth, ChunkGenerator chunkGen, StructureTemplateManager manager, List<? super PoolElementStructurePiece> pieces, RandomSource random) {
            this.pools = pools;
            this.maxDepth = maxDepth;
            this.chunkGen = chunkGen;
            this.manager = manager;
            this.pieces = pieces;
            this.random = random;
        }

        void tryPlacingChildren(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth, boolean useExpansionHack, LevelHeightAccessor level, RandomState random, PoolAliasLookup lookup, LiquidSettings liquidSettings) {
            StructurePoolElement element = piece.getElement();
            BlockPos pos = piece.getPosition();
            Rotation rotation = piece.getRotation();
            StructureTemplatePool.Projection projection = element.getProjection();
            boolean flag = projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableObject = new MutableObject<VoxelShape>();
            BoundingBox box = piece.getBoundingBox();
            int y = box.minY();
            block0: for (StructureTemplate.JigsawBlockInfo jigsawBlockInfo : element.getShuffledJigsawBlocks(this.manager, pos, rotation, this.random)) {
                StructurePoolElement poolElement;
                MutableObject<VoxelShape> mutableObject2;
                StructureTemplate.StructureBlockInfo info = jigsawBlockInfo.info();
                Direction direction = JigsawBlock.getFrontFacing((BlockState)info.state());
                BlockPos blockPos = info.pos();
                BlockPos blockPos1 = blockPos.relative(direction);
                int j = blockPos.getY() - y;
                int k = Integer.MIN_VALUE;
                ResourceKey<StructureTemplatePool> resourceKey = Placer.readPoolName(jigsawBlockInfo, lookup);
                Optional optional = this.pools.get(resourceKey);
                if (optional.isEmpty()) {
                    SlayersBeasts.LOGGER.warn("Empty or non-existent pool: {}", (Object)resourceKey.location());
                    continue;
                }
                Holder holder = (Holder)optional.get();
                if (((StructureTemplatePool)holder.value()).size() == 0 && !holder.is(Pools.EMPTY)) {
                    SlayersBeasts.LOGGER.warn("Empty or non-existent pool: {}", (Object)resourceKey.location());
                    continue;
                }
                Holder holder2 = ((StructureTemplatePool)holder.value()).getFallback();
                if (((StructureTemplatePool)holder2.value()).size() == 0 && !holder2.is(Pools.EMPTY)) {
                    SlayersBeasts.LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)holder2.unwrapKey().map(resourceKeyx -> resourceKeyx.location().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean bl2 = box.isInside((Vec3i)blockPos1);
                if (bl2) {
                    mutableObject2 = mutableObject;
                    if (mutableObject.getValue() == null) {
                        mutableObject.setValue((Object)Shapes.create((AABB)AABB.of((BoundingBox)box)));
                    }
                } else {
                    mutableObject2 = free;
                }
                ArrayList list = Lists.newArrayList();
                if (depth != this.maxDepth) {
                    list.addAll(((StructureTemplatePool)holder.value()).getShuffledTemplates(this.random));
                }
                list.addAll(((StructureTemplatePool)holder2.value()).getShuffledTemplates(this.random));
                int l = jigsawBlockInfo.placementPriority();
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (poolElement = (StructurePoolElement)iterator.next()) != EmptyPoolElement.INSTANCE) {
                    for (Rotation rotation2 : Rotation.getShuffled((RandomSource)this.random)) {
                        List list2 = poolElement.getShuffledJigsawBlocks(this.manager, BlockPos.ZERO, rotation2, this.random);
                        BoundingBox boundingBox2 = poolElement.getBoundingBox(this.manager, BlockPos.ZERO, rotation2);
                        int m = useExpansionHack && boundingBox2.getYSpan() <= 16 ? list2.stream().mapToInt(jigsawBlockInfox -> {
                            StructureTemplate.StructureBlockInfo structureBlockInfox = jigsawBlockInfox.info();
                            if (!boundingBox2.isInside((Vec3i)structureBlockInfox.pos().relative(JigsawBlock.getFrontFacing((BlockState)structureBlockInfox.state())))) {
                                return 0;
                            }
                            ResourceKey<StructureTemplatePool> resourceKeyx = Placer.readPoolName(jigsawBlockInfox, lookup);
                            Optional optionalx = this.pools.get(resourceKeyx);
                            Optional<Holder> optional2 = optionalx.map(holderx -> ((StructureTemplatePool)holderx.value()).getFallback());
                            int ix = optionalx.map(holderx -> ((StructureTemplatePool)holderx.value()).getMaxSize(this.manager)).orElse(0);
                            int jx = optional2.map(holderx -> ((StructureTemplatePool)holderx.value()).getMaxSize(this.manager)).orElse(0);
                            return Math.max(ix, jx);
                        }).max().orElse(0) : 0;
                        for (StructureTemplate.JigsawBlockInfo jigsawBlockInfo2 : list2) {
                            int u;
                            int s;
                            int q;
                            if (!JigsawBlock.canAttach((StructureTemplate.JigsawBlockInfo)jigsawBlockInfo, (StructureTemplate.JigsawBlockInfo)jigsawBlockInfo2)) continue;
                            BlockPos blockPos4 = jigsawBlockInfo2.info().pos();
                            BlockPos blockPos5 = blockPos1.subtract((Vec3i)blockPos4);
                            BoundingBox boundingBox3 = poolElement.getBoundingBox(this.manager, blockPos5, rotation2);
                            int n = boundingBox3.minY();
                            StructureTemplatePool.Projection projection2 = poolElement.getProjection();
                            boolean bl3 = projection2 == StructureTemplatePool.Projection.RIGID;
                            int o = blockPos4.getY();
                            int p = j - o + JigsawBlock.getFrontFacing((BlockState)info.state()).getStepY();
                            if (flag && bl3) {
                                q = y + p;
                            } else {
                                if (k == Integer.MIN_VALUE) {
                                    k = this.chunkGen.getFirstFreeHeight(blockPos.getX(), blockPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, level, random);
                                }
                                q = k - o;
                            }
                            int r = q - n;
                            BoundingBox boundingBox4 = boundingBox3.moved(0, r, 0);
                            BlockPos blockPos6 = blockPos5.offset(0, r, 0);
                            if (m > 0) {
                                s = Math.max(m + 1, boundingBox4.maxY() - boundingBox4.minY());
                                boundingBox4.encapsulate(new BlockPos(boundingBox4.minX(), boundingBox4.minY() + s, boundingBox4.minZ()));
                            }
                            if (Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)mutableObject2.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingBox4).deflate(0.25)), (BooleanOp)BooleanOp.ONLY_SECOND)) continue;
                            mutableObject2.setValue((Object)Shapes.joinUnoptimized((VoxelShape)((VoxelShape)mutableObject2.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingBox4)), (BooleanOp)BooleanOp.ONLY_FIRST));
                            s = piece.getGroundLevelDelta();
                            int t = bl3 ? s - p : poolElement.getGroundLevelDelta();
                            PoolElementStructurePiece poolElementStructurePiece = new PoolElementStructurePiece(this.manager, poolElement, blockPos6, t, rotation2, boundingBox4, liquidSettings);
                            if (flag) {
                                u = y + j;
                            } else if (bl3) {
                                u = q + o;
                            } else {
                                if (k == Integer.MIN_VALUE) {
                                    k = this.chunkGen.getFirstFreeHeight(blockPos.getX(), blockPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, level, random);
                                }
                                u = k + p / 2;
                            }
                            piece.addJunction(new JigsawJunction(blockPos1.getX(), u - j + s, blockPos1.getZ(), p, projection2));
                            poolElementStructurePiece.addJunction(new JigsawJunction(blockPos.getX(), u - o + t, blockPos.getZ(), -p, projection));
                            this.pieces.add((PoolElementStructurePiece)poolElementStructurePiece);
                            if (depth + 1 > this.maxDepth) continue block0;
                            PieceState pieceState = new PieceState(poolElementStructurePiece, mutableObject2, depth + 1);
                            this.placing.add((Object)pieceState, l);
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> readPoolName(StructureTemplate.JigsawBlockInfo info, PoolAliasLookup lookup) {
            return lookup.lookup(Pools.createKey((ResourceLocation)info.pool()));
        }
    }

    record PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth) {
    }
}

