/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.model;

import net.invictusslayer.slayersbeasts.client.animation.WitherSpiderAnimation;
import net.invictusslayer.slayersbeasts.world.entity.WitherSpider;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class WitherSpiderModel<T extends WitherSpider>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"wither_spider_model"), "main");
    private final ModelPart root;
    private final ModelPart head;

    public WitherSpiderModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("body").getChild("head");
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * (float)Math.PI / 180.0f;
        this.head.xRot = headPitch * (float)Math.PI / 180.0f;
        this.animateWalk(WitherSpiderAnimation.WALK, limbSwing, limbSwingAmount, 20.0f, 10.0f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(15, 15).addBox(-1.0f, -1.0f, 5.5f, 2.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(15, 4).addBox(0.0f, -2.0f, 6.5f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, 0.0f, 14.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, -2.0f, -6.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-5.5f));
        PartDefinition leg_left_front = body.addOrReplaceChild("leg_left_front", CubeListBuilder.create().texOffs(8, 37).addBox(0.0f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(34, 36).addBox(1.0f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)-2.5f, (float)0.6109f, (float)0.5236f, (float)0.9599f));
        PartDefinition cube_r1 = leg_left_front.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(28, 18).addBox(0.0f, 0.0f, -0.5f, 9.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition cube_r2 = leg_left_front.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(31, 4).addBox(-7.0f, 0.0f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition leg_left_mid_front = body.addOrReplaceChild("leg_left_mid_front", CubeListBuilder.create().texOffs(36, 28).addBox(0.0f, 0.0f, -0.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 35).addBox(1.0f, -4.0f, -0.75f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)-0.5f, (float)0.2618f, (float)0.1745f, (float)0.7854f));
        PartDefinition cube_r3 = leg_left_mid_front.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(28, 16).addBox(0.0f, 0.0f, -0.5f, 9.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-9.0f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition cube_r4 = leg_left_mid_front.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(31, 2).addBox(-7.0f, 0.0f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-9.0f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition leg_left_mid_hind = body.addOrReplaceChild("leg_left_mid_hind", CubeListBuilder.create().texOffs(14, 35).addBox(0.0f, 0.0f, -0.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(4, 35).addBox(1.0f, -4.0f, -0.25f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.5f, (float)-0.2618f, (float)-0.1745f, (float)0.7854f));
        PartDefinition cube_r5 = leg_left_mid_hind.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(28, 14).addBox(0.0f, 0.0f, -0.5f, 9.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-9.0f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition cube_r6 = leg_left_mid_hind.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(31, 0).addBox(-7.0f, 0.0f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-9.0f, (float)0.25f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition leg_left_hind = body.addOrReplaceChild("leg_left_hind", CubeListBuilder.create().texOffs(34, 33).addBox(0.0f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(30, 33).addBox(1.0f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)2.5f, (float)-0.6109f, (float)-0.5236f, (float)0.9599f));
        PartDefinition cube_r7 = leg_left_hind.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 28).addBox(0.0f, 0.0f, -0.5f, 9.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition cube_r8 = leg_left_hind.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(16, 30).addBox(-7.0f, 0.0f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition leg_right_front = body.addOrReplaceChild("leg_right_front", CubeListBuilder.create().texOffs(24, 32).addBox(-2.0f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(20, 32).addBox(-2.0f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)-2.5f, (float)0.6109f, (float)-0.5236f, (float)-0.9599f));
        PartDefinition cube_r9 = leg_right_front.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(20, 26).addBox(-9.0f, 0.0f, -0.5f, 9.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition cube_r10 = leg_right_front.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(0, 30).addBox(0.0f, 0.0f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition leg_right_mid_front = body.addOrReplaceChild("leg_right_mid_front", CubeListBuilder.create().texOffs(14, 32).addBox(-2.0f, 0.0f, -0.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 32).addBox(-2.0f, -4.0f, -0.75f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)-0.5f, (float)0.2618f, (float)-0.1745f, (float)-0.7854f));
        PartDefinition cube_r11 = leg_right_mid_front.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(26, 10).addBox(-9.0f, 0.0f, -0.5f, 9.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-9.0f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition cube_r12 = leg_right_mid_front.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(28, 22).addBox(0.0f, 0.0f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-9.0f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition leg_right_mid_hind = body.addOrReplaceChild("leg_right_mid_hind", CubeListBuilder.create().texOffs(4, 32).addBox(-2.0f, 0.0f, -0.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 32).addBox(-2.0f, -4.0f, -0.25f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)0.5f, (float)-0.2618f, (float)0.1745f, (float)-0.7854f));
        PartDefinition cube_r13 = leg_right_mid_hind.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(0, 26).addBox(-9.0f, 0.0f, -0.5f, 9.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-9.0f, (float)0.25f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition cube_r14 = leg_right_mid_hind.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(28, 20).addBox(0.0f, 0.0f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-9.0f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition leg_right_hind = body.addOrReplaceChild("leg_right_hind", CubeListBuilder.create().texOffs(18, 14).addBox(-2.0f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(-2.0f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)2.5f, (float)-0.6109f, (float)0.5236f, (float)-0.9599f));
        PartDefinition cube_r15 = leg_right_hind.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(18, 12).addBox(-9.0f, 0.0f, -0.5f, 9.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition cube_r16 = leg_right_hind.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(20, 28).addBox(0.0f, 0.0f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition thorax = body.addOrReplaceChild("thorax", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -6.0f, -5.5f, 2.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(15, 0).addBox(0.0f, -7.0f, -4.5f, 0.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(40, 32).addBox(-3.0f, -6.0f, -2.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(40, 34).addBox(-3.0f, -6.0f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(8, 40).addBox(-3.0f, -6.0f, 1.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(40, 26).addBox(1.0f, -6.0f, -2.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(39, 8).addBox(1.0f, -6.0f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 12).addBox(1.0f, -6.0f, 1.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition rib1 = thorax.addOrReplaceChild("rib1", CubeListBuilder.create().texOffs(42, 36).addBox(-2.0f, -6.0f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 28).addBox(-3.0f, -5.0f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rib2 = thorax.addOrReplaceChild("rib2", CubeListBuilder.create().texOffs(17, 42).addBox(-2.0f, -6.0f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(8, 42).addBox(-3.0f, -5.0f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)8.0f));
        PartDefinition rib3 = thorax.addOrReplaceChild("rib3", CubeListBuilder.create().texOffs(0, 42).addBox(-3.0f, -6.0f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(40, 41).addBox(-2.0f, -5.0f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition rib4 = thorax.addOrReplaceChild("rib4", CubeListBuilder.create().texOffs(36, 41).addBox(-3.0f, -6.0f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(32, 41).addBox(-2.0f, -5.0f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)8.0f));
        PartDefinition ribs_left = body.addOrReplaceChild("ribs_left", CubeListBuilder.create().texOffs(14, 0).addBox(1.0f, -6.0f, 5.5f, 4.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(31, 31).addBox(1.0f, -7.0f, 6.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(31, 6).addBox(1.0f, -7.0f, 9.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 8).addBox(1.0f, -7.0f, 12.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(33, 8).addBox(1.0f, -6.0f, 14.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(4, 40).addBox(4.0f, -6.0f, 6.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 36).addBox(5.0f, -6.0f, 9.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(28, 38).addBox(4.0f, -6.0f, 12.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(7, 0).addBox(2.0f, -5.0f, 14.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition ribs_right = body.addOrReplaceChild("ribs_right", CubeListBuilder.create().texOffs(6, 0).addBox(2.0f, -6.0f, 5.5f, 4.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(2.0f, -7.0f, 6.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 24).addBox(1.0f, -7.0f, 9.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 4).addBox(2.0f, -7.0f, 12.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(37, 24).addBox(4.0f, -6.0f, 14.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(14, 38).addBox(2.0f, -6.0f, 6.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(19, 37).addBox(1.0f, -6.0f, 9.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 37).addBox(2.0f, -6.0f, 12.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(23, 40).addBox(4.0f, -5.0f, 14.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

