/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.invictusslayer.slayersbeasts.client.model.AntCargoModel;
import net.invictusslayer.slayersbeasts.client.model.AntWorkerModel;
import net.invictusslayer.slayersbeasts.world.entity.AbstractAnt;
import net.invictusslayer.slayersbeasts.world.entity.AntWorker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AntCargoLayer<T extends AntWorker>
extends RenderLayer<T, AntWorkerModel<T>> {
    private static final ResourceLocation LEAF = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/cargo/leaf.png");
    private static final ResourceLocation BARK = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/cargo/bark.png");
    private final AntCargoModel<T> model;

    public AntCargoLayer(RenderLayerParent<T, AntWorkerModel<T>> parent, EntityModelSet set) {
        super(parent);
        this.model = new AntCargoModel(set.bakeLayer(AntCargoModel.LAYER_LOCATION));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((AbstractAnt)((Object)entity)).getCargoType() == 99) {
            return;
        }
        if (entity.isInvisible() && Minecraft.getInstance().shouldEntityAppearGlowing(entity)) {
            ((AntWorkerModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTick);
            this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.outline((ResourceLocation)LEAF));
            this.model.renderToBuffer(poseStack, consumer, packedLight, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f));
            return;
        }
        if (((AbstractAnt)((Object)entity)).getCargoType() == 1) {
            AntCargoLayer.renderColoredCutoutModel(this.model, (ResourceLocation)LEAF, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, entity, (int)-1);
        } else if (((AbstractAnt)((Object)entity)).getCargoType() == 2) {
            AntCargoLayer.renderColoredCutoutModel(this.model, (ResourceLocation)BARK, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, entity, (int)-1);
        }
    }
}

