/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data;

import java.util.function.Supplier;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class SBItemModelProvider
extends ItemModelProvider {
    public SBItemModelProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "slayersbeasts", helper);
    }

    protected void registerModels() {
        this.generateWoodFamilies();
        this.item(SBItems.MUSIC_DISC_INKISH);
        this.item(SBItems.JADE);
        this.item(SBItems.INSECT_CLAW);
        this.item(SBItems.INSECT_EYE);
        this.item(SBItems.INSECT_LEG);
        this.item(SBItems.FRIED_INSECT_LEG);
        this.item(SBItems.WITHERBONE);
        this.item(SBItems.TIED_LEATHER);
        this.item(SBItems.TANNED_LEATHER);
        this.item(SBItems.MUD_BALL);
        this.item(SBItems.MANTIS_SPAWN_EGG);
        this.item(SBItems.ANT_WORKER_SPAWN_EGG);
        this.item(SBItems.ANT_SOLDIER_SPAWN_EGG);
        this.item(SBItems.ANT_QUEEN_SPAWN_EGG);
        this.item(SBItems.WITHER_SPIDER_SPAWN_EGG);
        this.item(SBItems.TYRACHNID_SPAWN_EGG);
        this.item(SBItems.DAMSELFLY_SPAWN_EGG);
        this.item(SBItems.ENT_SPAWN_EGG);
        this.item(SBItems.WUDU_SPAWN_EGG);
        this.block(SBBlocks.ICICLE, "_frustum_down");
        this.block(SBBlocks.OBSIDIAN_SPIKE, "_tip_up");
        this.block(SBBlocks.TALL_DEAD_BUSH, "_top");
        this.block(SBBlocks.ALGAE);
        this.block(SBBlocks.TALL_BROWN_MUSHROOM, "_top");
        this.block(SBBlocks.TALL_RED_MUSHROOM, "_top");
        this.block(SBBlocks.BLACK_MUSHROOM);
        this.block(SBBlocks.TALL_BLACK_MUSHROOM, "_top");
        this.block(SBBlocks.WHITE_MUSHROOM);
        this.block(SBBlocks.TALL_WHITE_MUSHROOM, "_top");
        this.block(SBBlocks.ALBINO_REDWOOD_SAPLING);
        this.block(SBBlocks.WILLOW_BRANCH);
        this.block(SBBlocks.WILLOW_BRANCH_PLANT);
    }

    private void generateWoodFamilies() {
        SBWoodFamily.getAllFamilies().forEach(family -> family.getVariants().forEach((variant, supplier) -> {
            switch (variant) {
                case DOOR: 
                case BOAT: 
                case CHEST_BOAT: 
                case HANGING_SIGN_ITEM: 
                case SIGN_ITEM: {
                    this.item((Supplier<? extends ItemLike>)supplier);
                    break;
                }
                case SAPLING: {
                    this.block((Supplier<? extends Block>)supplier);
                }
            }
        }));
    }

    private void block(Supplier<? extends Block> block) {
        this.block(block, "");
    }

    private void block(Supplier<? extends Block> block, String suffix) {
        this.singleTexture(BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)("block/" + BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath() + suffix)));
    }

    private void item(Supplier<? extends ItemLike> item) {
        this.singleTexture(BuiltInRegistries.ITEM.getKey((Object)item.get().asItem()).getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)("item/" + BuiltInRegistries.ITEM.getKey((Object)item.get().asItem()).getPath())));
    }
}

