/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data.loot;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public class SBLootTables {
    private static final Set<ResourceKey<LootTable>> LOCATIONS = Sets.newHashSet();
    private static final Set<ResourceKey<LootTable>> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final ResourceKey<LootTable> CRYPT_COMMON = SBLootTables.register("chests/crypt_common");
    public static final ResourceKey<LootTable> CRYPT_RARE = SBLootTables.register("chests/crypt_rare");
    public static final ResourceKey<LootTable> REDWOOD_LOGS = SBLootTables.register("chests/redwood_logs");
    public static final ResourceKey<LootTable> REDWOOD_TOOLS = SBLootTables.register("chests/redwood_tools");

    private static ResourceKey<LootTable> register(String path) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)path));
        if (LOCATIONS.add((ResourceKey<LootTable>)key)) {
            return key;
        }
        throw new IllegalArgumentException(String.valueOf(key) + " is already a registered loot table");
    }

    public static Set<ResourceKey<LootTable>> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

