/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data.tags;

import java.util.concurrent.CompletableFuture;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class SBBlockTagsProvider
extends BlockTagsProvider {
    public SBBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        super(output, provider, "slayersbeasts", helper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.generateWoodFamilies();
        this.tag(SBTags.Blocks.SEPULCHRA_PORTAL_FRAME).add((Object)SBBlocks.JADE_BLOCK.get());
        this.tag(SBTags.Blocks.ANTHILLS).add((Object[])new Block[]{SBBlocks.ANTHILL.get(), SBBlocks.ANTHILL_HATCHERY.get()});
        this.tag(SBTags.Blocks.ANTHILL_REPLACEABLE).addTag(BlockTags.DIRT).addTag(BlockTags.BASE_STONE_OVERWORLD);
        this.tag(SBTags.Blocks.ICICLE_REPLACEABLE).add((Object[])new Block[]{Blocks.PACKED_ICE, Blocks.ICE, Blocks.BLUE_ICE}).addTag(BlockTags.BASE_STONE_OVERWORLD);
        this.tag(SBTags.Blocks.STYPHIUM_REPLACEABLE).addTag(BlockTags.BASE_STONE_OVERWORLD).addTag(BlockTags.DIRT);
        this.tag(BlockTags.SAND).add((Object)SBBlocks.BLACK_SAND.get());
        this.tag(BlockTags.DIRT).add((Object)SBBlocks.ARIDISOL.get());
        this.tag(BlockTags.LEAVES).add((Object)SBBlocks.ALBINO_REDWOOD_LEAVES.get());
        this.tag(BlockTags.SAPLINGS).add((Object)SBBlocks.ALBINO_REDWOOD_SAPLING.get());
        this.tag(BlockTags.SLABS).add((Object[])new Block[]{SBBlocks.PEGMATITE_SLAB.get(), SBBlocks.POLISHED_PEGMATITE_SLAB.get(), SBBlocks.BLACK_SANDSTONE_SLAB.get(), SBBlocks.SMOOTH_BLACK_SANDSTONE_SLAB.get(), SBBlocks.CUT_BLACK_SANDSTONE_SLAB.get()});
        this.tag(BlockTags.STAIRS).add((Object[])new Block[]{SBBlocks.PEGMATITE_STAIRS.get(), SBBlocks.POLISHED_PEGMATITE_STAIRS.get(), SBBlocks.BLACK_SANDSTONE_STAIRS.get(), SBBlocks.SMOOTH_BLACK_SANDSTONE_STAIRS.get()});
        this.tag(BlockTags.WALLS).add((Object[])new Block[]{SBBlocks.BLACK_SANDSTONE_WALL.get(), SBBlocks.PEGMATITE_WALL.get()});
        this.tag(BlockTags.MUSHROOM_GROW_BLOCK).add((Object[])new Block[]{SBBlocks.ARIDISOL.get(), SBBlocks.STYPHIUM.get(), SBBlocks.DEEPSLATE_STYPHIUM.get()});
        this.tag(BlockTags.SMELTS_TO_GLASS).add((Object)SBBlocks.BLACK_SAND.get());
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object[])new Block[]{SBBlocks.WHITE_MUSHROOM_BLOCK.get(), SBBlocks.WHITE_MUSHROOM.get(), SBBlocks.BLACK_MUSHROOM_BLOCK.get(), SBBlocks.BLACK_MUSHROOM.get()});
        this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object[])new Block[]{SBBlocks.PEAT.get(), SBBlocks.OOTHECA.get()}).addTag(BlockTags.LEAVES);
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{SBBlocks.OBSIDIAN_SPIKE.get(), SBBlocks.ICICLE.get(), SBBlocks.CRYPTALITH.get(), SBBlocks.INFUSED_CRYPTALITH.get(), SBBlocks.DEPLETED_CRYPTALITH.get(), SBBlocks.STYPHIUM.get(), SBBlocks.DEEPSLATE_STYPHIUM.get(), SBBlocks.PEGMATITE.get(), SBBlocks.PEGMATITE_SLAB.get(), SBBlocks.PEGMATITE_STAIRS.get(), SBBlocks.PEGMATITE_WALL.get(), SBBlocks.POLISHED_PEGMATITE.get(), SBBlocks.POLISHED_PEGMATITE_SLAB.get(), SBBlocks.POLISHED_PEGMATITE_STAIRS.get(), SBBlocks.CRACKED_MUD.get(), SBBlocks.JADE_BLOCK.get(), SBBlocks.EXOSKELETON_ORE.get(), SBBlocks.DEEPSLATE_EXOSKELETON_ORE.get(), SBBlocks.BLACK_SANDSTONE.get(), SBBlocks.BLACK_SANDSTONE_SLAB.get(), SBBlocks.BLACK_SANDSTONE_STAIRS.get(), SBBlocks.BLACK_SANDSTONE_WALL.get(), SBBlocks.SMOOTH_BLACK_SANDSTONE.get(), SBBlocks.SMOOTH_BLACK_SANDSTONE_SLAB.get(), SBBlocks.SMOOTH_BLACK_SANDSTONE_STAIRS.get(), SBBlocks.CUT_BLACK_SANDSTONE.get(), SBBlocks.CUT_BLACK_SANDSTONE_SLAB.get(), SBBlocks.CHISELED_BLACK_SANDSTONE.get()});
        this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object[])new Block[]{SBBlocks.BLACK_SAND.get(), SBBlocks.ARIDISOL.get()}).addTag(SBTags.Blocks.ANTHILLS);
        this.tag(BlockTags.NEEDS_DIAMOND_TOOL).add((Object[])new Block[]{SBBlocks.EXOSKELETON_ORE.get(), SBBlocks.DEEPSLATE_EXOSKELETON_ORE.get(), SBBlocks.OBSIDIAN_SPIKE.get()});
        this.tag(BlockTags.NEEDS_IRON_TOOL).add((Object)SBBlocks.JADE_BLOCK.get());
    }

    private void generateWoodFamilies() {
        SBWoodFamily.getAllFamilies().forEach(family -> {
            if (family.isFlammable()) {
                this.tag(BlockTags.LOGS_THAT_BURN).addTag(family.getLogBlocks());
            }
            family.getVariants().forEach((variant, supplier) -> {
                Object patt0$temp = supplier.get();
                if (!(patt0$temp instanceof Block)) {
                    return;
                }
                Block block = (Block)patt0$temp;
                switch (variant) {
                    case BUTTON: {
                        this.tag(BlockTags.WOODEN_BUTTONS).add((Object)block);
                        break;
                    }
                    case DOOR: {
                        this.tag(BlockTags.WOODEN_DOORS).add((Object)block);
                        break;
                    }
                    case FENCE: {
                        this.tag(BlockTags.WOODEN_FENCES).add((Object)block);
                        break;
                    }
                    case FENCE_GATE: {
                        this.tag(BlockTags.FENCE_GATES).add((Object)block);
                        break;
                    }
                    case HANGING_SIGN: {
                        this.tag(BlockTags.CEILING_HANGING_SIGNS).add((Object)block);
                        break;
                    }
                    case LEAVES: {
                        this.tag(BlockTags.LEAVES).add((Object)block);
                        break;
                    }
                    case LOG: 
                    case STRIPPED_LOG: 
                    case STRIPPED_WOOD: 
                    case WOOD: {
                        this.tag(family.getLogBlocks()).add((Object)block);
                        break;
                    }
                    case SAPLING: {
                        this.tag(BlockTags.SAPLINGS).add((Object)block);
                        break;
                    }
                    case SIGN: {
                        this.tag(BlockTags.STANDING_SIGNS).add((Object)block);
                        break;
                    }
                    case SLAB: {
                        this.tag(BlockTags.WOODEN_SLABS).add((Object)block);
                        break;
                    }
                    case STAIRS: {
                        this.tag(BlockTags.WOODEN_STAIRS).add((Object)block);
                        break;
                    }
                    case PLANKS: {
                        this.tag(BlockTags.PLANKS).add((Object)block);
                        break;
                    }
                    case PRESSURE_PLATE: {
                        this.tag(BlockTags.WOODEN_PRESSURE_PLATES).add((Object)block);
                        break;
                    }
                    case TRAPDOOR: {
                        this.tag(BlockTags.WOODEN_TRAPDOORS).add((Object)block);
                        break;
                    }
                    case WALL_HANGING_SIGN: {
                        this.tag(BlockTags.WALL_HANGING_SIGNS).add((Object)block);
                        break;
                    }
                    case WALL_SIGN: {
                        this.tag(BlockTags.WALL_SIGNS).add((Object)block);
                    }
                }
            });
        });
    }
}

