/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.registries;

import java.util.List;
import java.util.function.Supplier;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.world.level.biome.SBBiomes;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class SBVillagerType {
    public static final Supplier<VillagerType> CAVE = SBVillagerType.register("cave", () -> new VillagerType("cave"));

    public static void setupBiomes() {
        SBVillagerType.addBiomes(VillagerType.DESERT, SBBiomes.BLACK_DUNES, SBBiomes.DEAD_SANDS, SBBiomes.OUTBACK);
        SBVillagerType.addBiomes(VillagerType.JUNGLE, SBBiomes.ANCIENT_GROVE, SBBiomes.EUCALYPT_WOODLAND, SBBiomes.RAINFOREST);
        SBVillagerType.addBiomes(VillagerType.SAVANNA, SBBiomes.BRUSHLAND, SBBiomes.ROCKY_BRUSHLAND, SBBiomes.WOODED_BRUSHLAND);
        SBVillagerType.addBiomes(VillagerType.SNOW, SBBiomes.FROZEN_THICKET, SBBiomes.GLACIATE_SWAMP, SBBiomes.PETRIFIED_WOODS);
        SBVillagerType.addBiomes(VillagerType.SWAMP, SBBiomes.BAYOU, SBBiomes.INKY_MOOR);
        SBVillagerType.addBiomes(VillagerType.TAIGA, SBBiomes.ASPEN_FOREST);
        SBVillagerType.addBiomes(CAVE.get(), Biomes.LUSH_CAVES, Biomes.DEEP_DARK, Biomes.DRIPSTONE_CAVES, SBBiomes.SLIME_CAVERNS, SBBiomes.DUSTY_CAVERNS, SBBiomes.ICE_CAVES, SBBiomes.FUNGAL_DEPTHS);
    }

    @SafeVarargs
    private static void addBiomes(VillagerType type, ResourceKey<Biome> ... biomes) {
        List.of(biomes).forEach(biome -> VillagerType.BY_BIOME.put(biome, type));
    }

    private static <T extends VillagerType> Supplier<T> register(String name, Supplier<T> supplier) {
        return SlayersBeasts.PLATFORM.register((Registry)BuiltInRegistries.VILLAGER_TYPE, "slayersbeasts", name, supplier);
    }

    public static void register() {
        SlayersBeasts.LOGGER.info("Registering SBVillagerTypes...");
    }
}

