/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.entity;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.world.entity.AntQueen;
import net.invictusslayer.slayersbeasts.world.entity.AntSoldier;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.Path;

public abstract class AbstractAnt
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(AbstractAnt.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_CARGO_TYPE = SynchedEntityData.defineId(AbstractAnt.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int cooldownToEnterNest;
    private int cooldownToLocateNest;
    private int failedForagingTime;
    BlockPos nestPos;
    AntGoToNestGoal antGoToNestGoal;

    public AbstractAnt(EntityType<? extends AbstractAnt> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AntEnterNestGoal(this));
        this.goalSelector.addGoal(2, (Goal)new AntLocateNestGoal(this));
        this.antGoToNestGoal = new AntGoToNestGoal(this);
        this.goalSelector.addGoal(3, (Goal)this.antGoToNestGoal);
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AntAttackedGoal(this).setAlertOthers(new Class[0]));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.nestPos != null) {
            tag.put("NestPos", NbtUtils.writeBlockPos((BlockPos)this.nestPos));
        }
        tag.putInt("CooldownToEnterNest", this.cooldownToEnterNest);
        tag.putInt("FailedForagingTime", this.failedForagingTime);
        tag.putInt("Variant", this.getVariant().getId());
        tag.putInt("CargoType", this.getCargoType());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.nestPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"NestPos").orElse(null);
        this.setCooldownToEnterNest(tag.getInt("CooldownToEnterNest"));
        this.failedForagingTime = tag.getInt("FailedForagingTime");
        this.setVariant(Variant.byId(tag.getInt("Variant")));
        this.setCargoType(tag.getInt("CargoType"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)0);
        builder.define(DATA_CARGO_TYPE, (Object)0);
    }

    public void setCooldownToEnterNest(int cooldown) {
        this.cooldownToEnterNest = cooldown;
    }

    public int getCargoType() {
        return (Integer)this.entityData.get(DATA_CARGO_TYPE);
    }

    public void setCargoType(int type) {
        if (type != 99) {
            this.failedForagingTime = 0;
        }
        this.entityData.set(DATA_CARGO_TYPE, (Object)type);
    }

    public void aiStep() {
        super.aiStep();
        if (this.cooldownToEnterNest > 0) {
            --this.cooldownToEnterNest;
        }
        if (this.cooldownToLocateNest > 0) {
            --this.cooldownToLocateNest;
        }
        if (this.getCargoType() == 99) {
            ++this.failedForagingTime;
        }
        if (this.tickCount % 20 == 0 && !this.hasValidNest()) {
            this.nestPos = null;
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, SpawnGroupData spawnData) {
        Variant variant = this.getRandomAntType((LevelAccessor)level);
        if (spawnData instanceof AntGroupData) {
            AntGroupData antData = (AntGroupData)spawnData;
            variant = antData.variant;
        } else {
            spawnData = new AntGroupData(variant);
        }
        this.setVariant(variant);
        return spawnData;
    }

    private Variant getRandomAntType(LevelAccessor level) {
        Holder holder = level.getBiome(this.blockPosition());
        if (holder.is(SBTags.Biomes.SPAWNS_WOOD_ANTS)) {
            return Variant.WOOD;
        }
        if (holder.is(SBTags.Biomes.SPAWNS_LEAFCUTTER_ANTS)) {
            return Variant.LEAFCUTTER;
        }
        if (holder.is(SBTags.Biomes.SPAWNS_MEADOW_ANTS)) {
            return Variant.MEADOW;
        }
        return Variant.byId(level.getRandom().nextInt(Variant.values().length));
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT));
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_VARIANT, (Object)variant.ordinal());
    }

    public void setNestPos(BlockPos pos) {
        this.nestPos = pos;
    }

    public BlockPos getNestPos() {
        return this.nestPos;
    }

    boolean hasValidNest() {
        if (this.nestPos == null) {
            return false;
        }
        BlockEntity blockEntity = this.level().getBlockEntity(this.nestPos);
        return blockEntity instanceof AnthillBlockEntity;
    }

    private boolean nestHasSpace(BlockPos nestPos) {
        BlockEntity blockEntity = this.level().getBlockEntity(nestPos);
        if (blockEntity instanceof AnthillBlockEntity) {
            AnthillBlockEntity anthill = (AnthillBlockEntity)blockEntity;
            return !anthill.isFull() && (anthill.getInhabitantVariant() == null || anthill.getInhabitantVariant() == this.getVariant());
        }
        return false;
    }

    protected boolean wantsToEnterNest(AbstractAnt ant) {
        if (this.cooldownToEnterNest > 0) {
            return false;
        }
        return this.failedForagingTime > 3600 || this.getCargoType() != 99 || this.level().isRaining() || ant instanceof AntQueen;
    }

    boolean closerThan(BlockPos pos, double distance) {
        return pos.closerThan((Vec3i)this.blockPosition(), distance);
    }

    static class AntEnterNestGoal
    extends Goal {
        private final AbstractAnt ant;

        public AntEnterNestGoal(AbstractAnt ant) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.ant = ant;
        }

        public boolean canUse() {
            return this.ant.nestPos != null && this.ant.wantsToEnterNest(this.ant) && this.ant.nestHasSpace(this.ant.nestPos) && this.ant.position().distanceToSqr((double)this.ant.nestPos.getX() + 0.5, (double)this.ant.nestPos.getY() + 1.0, (double)this.ant.nestPos.getZ() + 0.5) <= 0.4;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            BlockEntity blockEntity = this.ant.level().getBlockEntity(this.ant.nestPos);
            if (blockEntity instanceof AnthillBlockEntity) {
                AnthillBlockEntity anthill = (AnthillBlockEntity)blockEntity;
                anthill.addOccupant((Entity)this.ant, this.ant.getVariant());
            }
        }
    }

    static class AntLocateNestGoal
    extends Goal {
        private final AbstractAnt ant;

        public AntLocateNestGoal(AbstractAnt ant) {
            this.ant = ant;
        }

        public boolean canUse() {
            return this.ant.cooldownToLocateNest == 0 && this.ant.nestPos == null && this.ant.wantsToEnterNest(this.ant);
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            this.ant.cooldownToLocateNest = 200;
            List<BlockPos> list = this.findNestWithSpace();
            if (list.isEmpty()) {
                return;
            }
            for (BlockPos pos : list) {
                if (this.ant.antGoToNestGoal.isTargetBlacklisted(pos)) continue;
                this.ant.nestPos = pos;
                return;
            }
            this.ant.antGoToNestGoal.clearBlacklist();
            this.ant.nestPos = list.get(0);
        }

        private List<BlockPos> findNestWithSpace() {
            BlockPos pos = this.ant.blockPosition();
            PoiManager poiManager = ((ServerLevel)this.ant.level()).getPoiManager();
            Stream stream = poiManager.getInRange(poiType -> poiType.is(SBTags.PoiTypes.ANT_HOME), pos, 20, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::getPos).filter(this.ant::nestHasSpace).sorted(Comparator.comparingDouble(key -> key.distSqr((Vec3i)pos))).collect(Collectors.toList());
        }
    }

    static class AntGoToNestGoal
    extends Goal {
        int travellingTicks;
        final List<BlockPos> blacklistedTargets = Lists.newArrayList();
        private Path lastPath;
        private int timeStuck;
        private final AbstractAnt ant;

        AntGoToNestGoal(AbstractAnt ant) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.ant = ant;
            this.travellingTicks = ant.level().random.nextInt(10);
        }

        public boolean canUse() {
            return this.ant.nestPos != null && !this.ant.hasRestriction() && this.ant.wantsToEnterNest(this.ant) && this.ant.nestHasSpace(this.ant.nestPos) && !this.hasReachedTarget(this.ant.nestPos) && this.ant.level().getBlockState(this.ant.nestPos).is(SBTags.Blocks.ANTHILLS);
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void start() {
            this.travellingTicks = 0;
            this.timeStuck = 0;
        }

        public void stop() {
            this.travellingTicks = 0;
            this.timeStuck = 0;
            this.ant.navigation.stop();
        }

        public void tick() {
            if (this.ant.nestPos != null) {
                ++this.travellingTicks;
                if (this.travellingTicks > this.adjustedTickDelay(600)) {
                    this.blacklistNest();
                } else if (!this.ant.navigation.isInProgress()) {
                    if (!this.ant.closerThan(this.ant.nestPos, 16.0)) {
                        if (!this.ant.closerThan(this.ant.nestPos, 32.0)) {
                            this.dropNest();
                        } else {
                            this.moveToNest(this.ant.nestPos);
                        }
                    } else if (!this.moveToNest(this.ant.nestPos)) {
                        this.blacklistNest();
                    } else if (this.lastPath != null && this.lastPath.sameAs(this.ant.navigation.getPath())) {
                        ++this.timeStuck;
                        if (this.timeStuck > 60) {
                            this.dropNest();
                            this.timeStuck = 0;
                        }
                    } else {
                        this.lastPath = this.ant.navigation.getPath();
                    }
                }
            }
        }

        private boolean moveToNest(BlockPos pPos) {
            this.ant.navigation.moveTo(this.ant.navigation.createPath(new BlockPos((Vec3i)pPos), 0), 1.0);
            return this.ant.navigation.getPath() != null && this.ant.navigation.getPath().canReach();
        }

        private boolean hasReachedTarget(BlockPos target) {
            return this.ant.position().distanceToSqr((double)target.getX() + 0.5, (double)target.getY() + 1.0, (double)target.getZ() + 0.5) <= 0.4;
        }

        private void dropNest() {
            this.ant.nestPos = null;
            this.ant.cooldownToLocateNest = 200;
        }

        private void blacklistNest() {
            if (this.ant.nestPos != null) {
                this.blacklistedTargets.add(this.ant.nestPos);
            }
            while (this.blacklistedTargets.size() > 3) {
                this.blacklistedTargets.remove(0);
            }
            this.dropNest();
        }

        boolean isTargetBlacklisted(BlockPos pPos) {
            return this.blacklistedTargets.contains(pPos);
        }

        void clearBlacklist() {
            this.blacklistedTargets.clear();
        }
    }

    static class AntAttackedGoal
    extends HurtByTargetGoal {
        AntAttackedGoal(AbstractAnt ant) {
            super((PathfinderMob)ant, new Class[0]);
        }

        public boolean canContinueToUse() {
            AntSoldier ant;
            Mob mob = this.mob;
            return mob instanceof AntSoldier && (ant = (AntSoldier)mob).isAngry() && super.canContinueToUse();
        }

        protected void alertOther(Mob mob, LivingEntity target) {
            if (mob instanceof AntSoldier) {
                AntSoldier soldier = (AntSoldier)mob;
                if (this.mob.hasLineOfSight((Entity)target) && ((AbstractAnt)this.mob).getVariant() == soldier.getVariant()) {
                    mob.setTarget(target);
                }
            }
        }
    }

    public static enum Variant implements StringRepresentable
    {
        WOOD(0, "wood"),
        LEAFCUTTER(1, "leafcutter"),
        MEADOW(2, "meadow");

        private static final IntFunction<Variant> BY_ID;
        final int id;
        final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public int getId() {
            return this.id;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public static class AntGroupData
    implements SpawnGroupData {
        private final Variant variant;

        private AntGroupData(Variant variant) {
            this.variant = variant;
        }
    }
}

