/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.entity;

import java.util.Objects;
import net.invictusslayer.slayersbeasts.registries.SBEntities;
import net.invictusslayer.slayersbeasts.registries.SBSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class Mantis
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_STRIKING = SynchedEntityData.defineId(Mantis.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_SCUTTLING = SynchedEntityData.defineId(Mantis.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_LEAPING = SynchedEntityData.defineId(Mantis.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDimensions SCUTTLING_DIMENSIONS = EntityDimensions.scalable((float)SBEntities.MANTIS.get().getWidth(), (float)(SBEntities.MANTIS.get().getHeight() - 0.8f));
    public final AnimationState flapAnimationState = new AnimationState();
    public final AnimationState strikeAnimationState = new AnimationState();

    public Mantis(EntityType<Mantis> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MantisScuttleGoal(this, 1.5, 32.0f, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new MantisLeapGoal(this, 0.6f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new MantisPreenGoal(this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MAX_HEALTH, 15.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ATTACK_SPEED, 2.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public boolean doHurtTarget(Entity entity) {
        if (!super.doHurtTarget(entity)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.random.nextBoolean()) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 30), (Entity)this);
            }
        }
        return true;
    }

    protected SoundEvent getAmbientSound() {
        return SBSounds.MANTIS_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return SBSounds.MANTIS_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SBSounds.MANTIS_HURT.get();
    }

    public static boolean canSpawn(EntityType<Mantis> entity, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        Level level1;
        return PathfinderMob.checkMobSpawnRules(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && level instanceof Level && (level1 = (Level)level).getDifficulty() != Difficulty.PEACEFUL;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_STRIKING, (Object)false);
        builder.define(DATA_IS_SCUTTLING, (Object)false);
        builder.define(DATA_IS_LEAPING, (Object)false);
    }

    public void tick() {
        super.tick();
        if (this.getTarget() != null) {
            this.setStriking(this.getTarget().distanceToSqr((Entity)this) < 8.0);
        } else {
            this.setStriking(false);
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.flapAnimationState.animateWhen(this.isLeaping(), this.tickCount);
        this.strikeAnimationState.animateWhen(this.isStriking(), this.tickCount);
    }

    public boolean isStriking() {
        return (Boolean)this.entityData.get(DATA_IS_STRIKING);
    }

    public void setStriking(boolean striking) {
        this.entityData.set(DATA_IS_STRIKING, (Object)striking);
    }

    public boolean isScuttling() {
        return (Boolean)this.entityData.get(DATA_IS_SCUTTLING);
    }

    public void setScuttling(Boolean scuttling) {
        this.entityData.set(DATA_IS_SCUTTLING, (Object)scuttling);
    }

    public boolean isLeaping() {
        return (Boolean)this.entityData.get(DATA_IS_LEAPING);
    }

    public void setLeaping(Boolean leaping) {
        this.entityData.set(DATA_IS_LEAPING, (Object)leaping);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isScuttling() ? SCUTTLING_DIMENSIONS.scale(this.getScale()) : super.getDefaultDimensions(pose);
    }

    static class MantisScuttleGoal
    extends MoveTowardsTargetGoal {
        private final Mantis mantis;
        private final float outside;

        public MantisScuttleGoal(Mantis mantis, double speedModifier, float within, float outside) {
            super((PathfinderMob)mantis, speedModifier, within);
            this.mantis = mantis;
            this.outside = outside;
        }

        public boolean canUse() {
            return super.canUse() && Objects.requireNonNull(this.mantis.getTarget()).distanceToSqr((Entity)this.mantis) > (double)(this.outside * this.outside);
        }

        public void start() {
            this.mantis.setScuttling(true);
            super.start();
        }

        public void stop() {
            this.mantis.setScuttling(false);
            super.stop();
        }
    }

    static class MantisLeapGoal
    extends LeapAtTargetGoal {
        private final Mantis mantis;

        public MantisLeapGoal(Mantis mantis, float yd) {
            super((Mob)mantis, yd);
            this.mantis = mantis;
        }

        public void start() {
            this.mantis.setLeaping(true);
            super.start();
        }

        public void stop() {
            this.mantis.setLeaping(false);
        }
    }

    static class MantisPreenGoal
    extends Goal {
        private final Mantis mantis;
        private int preenTime;

        public MantisPreenGoal(Mantis mantis) {
            this.mantis = mantis;
        }

        public boolean canUse() {
            return this.mantis.onGround() && this.mantis.getRandom().nextFloat() < 0.02f;
        }

        public boolean canContinueToUse() {
            return this.preenTime >= 0;
        }

        public void start() {
            this.preenTime = 15 + this.mantis.getRandom().nextInt(15);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            --this.preenTime;
        }
    }
}

