/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.invictusslayer.slayersbeasts.registries.SBBlockEntities;
import net.invictusslayer.slayersbeasts.world.entity.AntSoldier;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillBlockEntity;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillHatcheryBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class AnthillHatcheryBlock
extends BaseEntityBlock {
    public static final MapCodec<AnthillHatcheryBlock> CODEC = AnthillHatcheryBlock.simpleCodec(AnthillHatcheryBlock::new);
    public static final IntegerProperty LARVAL_STAGE = IntegerProperty.create((String)"larval_stage", (int)0, (int)5);
    public static final IntegerProperty LARVA = IntegerProperty.create((String)"larva", (int)0, (int)3);

    public AnthillHatcheryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LARVAL_STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)LARVA, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LARVAL_STAGE, LARVA});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AnthillHatcheryBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return AnthillHatcheryBlock.createTickerHelper(type, SBBlockEntities.ANTHILL_HATCHERY.get(), AnthillHatcheryBlockEntity::serverTick);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void angerNearbyAnts(Level level, BlockPos pos) {
        List list = level.getEntitiesOfClass(AntSoldier.class, new AABB(pos).inflate(8.0, 6.0, 8.0));
        if (!list.isEmpty()) {
            List players = level.getEntitiesOfClass(Player.class, new AABB(pos).inflate(8.0, 6.0, 8.0));
            if (players.isEmpty()) {
                return;
            }
            int i = players.size();
            for (AntSoldier ant : list) {
                if (ant.getTarget() != null) continue;
                ant.setTarget((LivingEntity)players.get(level.random.nextInt(i)));
            }
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity entity, ItemStack item) {
        super.playerDestroy(level, player, pos, state, entity, item);
        if (!level.isClientSide && entity instanceof AnthillHatcheryBlockEntity) {
            AnthillHatcheryBlockEntity blockEntity = (AnthillHatcheryBlockEntity)entity;
            BlockEntity base = level.getBlockEntity(blockEntity.getParentNestPos());
            if (base instanceof AnthillBlockEntity) {
                AnthillBlockEntity anthill = (AnthillBlockEntity)base;
                anthill.emptyAntsFromNest(player, anthill.getBlockState(), AnthillBlockEntity.AntReleaseStatus.EMERGENCY);
            }
            this.angerNearbyAnts(level, blockEntity.getParentNestPos());
        }
    }
}

