/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.block;

import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ObsidianSpikeBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public ObsidianSpikeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return ObsidianSpikeBlock.isValidPlacement(level, pos, (Direction)state.getValue((Property)TIP_DIRECTION));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        Direction tipDirection = (Direction)state.getValue((Property)TIP_DIRECTION);
        if (tipDirection == Direction.DOWN && level.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            return state;
        }
        if (direction == tipDirection.getOpposite() && !this.canSurvive(state, (LevelReader)level, pos)) {
            if (tipDirection == Direction.DOWN) {
                level.scheduleTick(pos, (Block)this, 2);
            } else {
                level.scheduleTick(pos, (Block)this, 1);
            }
            return state;
        }
        DripstoneThickness thickness = ObsidianSpikeBlock.calculateThickness((LevelReader)level, pos, tipDirection, state.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE);
        return (BlockState)state.setValue(THICKNESS, (Comparable)thickness);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP && state.getValue(THICKNESS) == DripstoneThickness.TIP) {
            entity.causeFallDamage(fallDistance + 2.0f, 2.0f, level.damageSources().stalagmite());
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (ObsidianSpikeBlock.isSpikeWithDirection(state, Direction.UP) && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        } else {
            ObsidianSpikeBlock.spawnFallingStalactite(state, level, pos);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction;
        BlockPos pos;
        Level level = context.getLevel();
        Direction tipDirection = ObsidianSpikeBlock.calculateTipDirection((LevelReader)level, pos = context.getClickedPos(), direction = context.getNearestLookingVerticalDirection().getOpposite());
        if (tipDirection == null) {
            return null;
        }
        DripstoneThickness thickness = ObsidianSpikeBlock.calculateThickness((LevelReader)level, pos, tipDirection, !context.isSecondaryUseActive());
        return thickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)tipDirection)).setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        DripstoneThickness thickness = (DripstoneThickness)state.getValue(THICKNESS);
        VoxelShape shape = thickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (thickness == DripstoneThickness.TIP ? (state.getValue((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (thickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (thickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = state.getOffset(getter, pos);
        return shape.move(vec3.x, 0.0, vec3.z);
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (!fallingBlock.isSilent()) {
            level.levelEvent(1045, pos, 0);
        }
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fallingStalactite(entity);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        BlockState blockState = state;
        while (ObsidianSpikeBlock.isSpikeWithDirection(blockState, Direction.DOWN)) {
            FallingBlockEntity fallingBlock = FallingBlockEntity.fall((Level)level, (BlockPos)mutableBlockPos, (BlockState)blockState);
            fallingBlock.disableDrop();
            if (ObsidianSpikeBlock.isTip(blockState, true)) {
                fallingBlock.setHurtsEntities((float)Math.max(1 + pos.getY() - mutableBlockPos.getY(), 6), 40);
                break;
            }
            mutableBlockPos.move(Direction.DOWN);
            blockState = level.getBlockState((BlockPos)mutableBlockPos);
        }
    }

    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction direction) {
        if (ObsidianSpikeBlock.isValidPlacement(level, pos, direction)) {
            return direction;
        }
        if (!ObsidianSpikeBlock.isValidPlacement(level, pos, direction.getOpposite())) {
            return null;
        }
        return direction.getOpposite();
    }

    private static DripstoneThickness calculateThickness(LevelReader level, BlockPos pos, Direction direction, boolean isMerged) {
        Direction opposite = direction.getOpposite();
        BlockState state = level.getBlockState(pos.relative(direction));
        if (ObsidianSpikeBlock.isSpikeWithDirection(state, opposite)) {
            return !isMerged && state.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!ObsidianSpikeBlock.isSpikeWithDirection(state, direction)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness thickness = (DripstoneThickness)state.getValue(THICKNESS);
        if (thickness != DripstoneThickness.TIP && thickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockState = level.getBlockState(pos.relative(opposite));
            return !ObsidianSpikeBlock.isSpikeWithDirection(blockState, direction) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    private static boolean isValidPlacement(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState state = level.getBlockState(blockPos);
        return state.isFaceSturdy((BlockGetter)level, blockPos, direction) || ObsidianSpikeBlock.isSpikeWithDirection(state, direction);
    }

    private static boolean isTip(BlockState state, boolean isMerged) {
        if (!state.is(SBBlocks.OBSIDIAN_SPIKE.get())) {
            return false;
        }
        DripstoneThickness thickness = (DripstoneThickness)state.getValue(THICKNESS);
        return thickness == DripstoneThickness.TIP || isMerged && thickness == DripstoneThickness.TIP_MERGE;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    private static boolean isSpikeWithDirection(BlockState state, Direction direction) {
        return state.is(SBBlocks.OBSIDIAN_SPIKE.get()) && state.getValue((Property)TIP_DIRECTION) == direction;
    }
}

