/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.dimension;

import java.util.OptionalLong;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;

public class SBDimensions {
    public static final ResourceKey<Level> CRYPT = SBDimensions.createDimensionKey("crypt");
    public static final ResourceKey<DimensionType> CRYPT_TYPE = SBDimensions.createDimensionTypeKey("crypt");
    public static final ResourceKey<Level> SEPULCHRA = SBDimensions.createDimensionKey("sepulchra");
    public static final ResourceKey<DimensionType> SEPULCHRA_TYPE = SBDimensions.createDimensionTypeKey("sepulchra");

    public static void bootstrap(BootstrapContext<DimensionType> context) {
        SBDimensions.register(context, CRYPT_TYPE, new DimensionType(OptionalLong.of(6000L), false, true, false, false, 1.0, false, false, 0, 128, 128, BlockTags.INFINIBURN_OVERWORLD, BuiltinDimensionTypes.END_EFFECTS, 0.0f, new DimensionType.MonsterSettings(true, false, (IntProvider)UniformInt.of((int)0, (int)14), 14)));
        SBDimensions.register(context, SEPULCHRA_TYPE, new DimensionType(OptionalLong.of(12000L), true, false, false, false, 1.0, true, true, -64, 384, 384, BlockTags.INFINIBURN_OVERWORLD, BuiltinDimensionTypes.OVERWORLD_EFFECTS, 0.0f, new DimensionType.MonsterSettings(false, true, (IntProvider)UniformInt.of((int)0, (int)7), 7)));
    }

    private static ResourceKey<Level> createDimensionKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)name));
    }

    private static ResourceKey<DimensionType> createDimensionTypeKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)name));
    }

    private static void register(BootstrapContext<DimensionType> context, ResourceKey<DimensionType> key, DimensionType type) {
        context.register(key, (Object)type);
    }
}

