/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class PitFeature
extends Feature<Configuration> {
    public PitFeature(Codec<Configuration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        int y1;
        int x1;
        int zMax;
        int xMax;
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        Configuration config = (Configuration)context.config();
        int x = config.x();
        int y = config.y();
        int z = config.z();
        int n = xMax = x < 7 ? 8 : 16;
        int yMax = y < 7 ? 8 : (y < 15 ? 16 : 32);
        int n2 = zMax = z < 7 ? 8 : 16;
        if (origin.getY() <= level.getMinBuildHeight() + y) {
            return false;
        }
        if (!level.canSeeSky((origin = origin.below(y)).offset(xMax / 2, y, zMax / 2))) {
            return false;
        }
        boolean[] booleans = new boolean[xMax * yMax * zMax];
        for (int i = 0; i < y * 2; ++i) {
            double d0 = random.nextDouble() * 4.0 + 3.0;
            double d1 = random.nextDouble() * 6.0 + 2.0;
            double d2 = random.nextDouble() * 4.0 + 3.0;
            double d3 = random.nextDouble() * ((double)x - d0) + 1.0 + d0 / 2.0;
            double d4 = random.nextDouble() * ((double)y - d1) + 1.0 + d1 / 2.0;
            double d5 = random.nextDouble() * ((double)z - d2) + 1.0 + d2 / 2.0;
            for (int x12 = 1; x12 < xMax - 1; ++x12) {
                for (int z1 = 1; z1 < zMax - 1; ++z1) {
                    for (int y12 = 1; y12 < y - 1; ++y12) {
                        double d6 = ((double)x12 - d3) / (d0 / 2.0);
                        double d7 = ((double)y12 - d4) / (d1 / 2.0);
                        double d8 = ((double)z1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        booleans[(x12 * zMax + z1) * yMax + y12] = true;
                    }
                }
            }
        }
        for (x1 = 0; x1 < xMax; ++x1) {
            for (int z1 = 0; z1 < zMax; ++z1) {
                for (y1 = 0; y1 < yMax; ++y1) {
                    boolean flag;
                    int boolId = (x1 * zMax + z1) * yMax + y1;
                    boolean bl = flag = !booleans[boolId] && (x1 < xMax - 1 && booleans[boolId + zMax * yMax] || x1 > 0 && booleans[boolId - zMax * yMax] || z1 < zMax - 1 && booleans[boolId + yMax] || z1 > 0 && booleans[boolId - yMax] || y1 < yMax - 1 && booleans[boolId + 1] || y1 > 0 && booleans[boolId - 1]);
                    if (!flag) continue;
                    BlockState state = level.getBlockState(origin.offset(x1, y1, z1));
                    if (state.liquid()) {
                        return false;
                    }
                    if (y1 >= y || state.isSolid() || level.getBlockState(origin.offset(x1, y1, z1)) == Blocks.CAVE_AIR.defaultBlockState()) continue;
                    return false;
                }
            }
        }
        for (x1 = 0; x1 < xMax; ++x1) {
            for (int z1 = 0; z1 < zMax; ++z1) {
                for (y1 = 0; y1 < yMax; ++y1) {
                    BlockPos pos;
                    if (!booleans[(x1 * zMax + z1) * yMax + y1] || level.getBlockState(pos = origin.offset(x1, y1, z1)).is(BlockTags.FEATURES_CANNOT_REPLACE)) continue;
                    level.setBlock(pos, Blocks.CAVE_AIR.defaultBlockState(), 2);
                    this.markAboveForPostProcessing(level, pos);
                }
            }
        }
        BlockState wall = config.wall().getState(random, origin);
        BlockState ceiling = config.ceiling().getState(random, origin);
        if (wall.isAir()) {
            return true;
        }
        for (int x13 = 0; x13 < xMax; ++x13) {
            for (int z1 = 0; z1 < zMax; ++z1) {
                for (int y13 = 0; y13 < yMax; ++y13) {
                    BlockPos pos;
                    BlockState state;
                    boolean flag;
                    int boolId = (x13 * zMax + z1) * yMax + y13;
                    boolean bl = flag = !booleans[boolId] && (x13 < xMax - 1 && booleans[boolId + zMax * yMax] || x13 > 0 && booleans[boolId - zMax * yMax] || z1 < zMax - 1 && booleans[boolId + yMax] || z1 > 0 && booleans[boolId - yMax] || y13 < yMax - 1 && booleans[boolId + 1] || y13 > 0 && booleans[boolId - 1]);
                    if (!flag || (state = level.getBlockState(pos = origin.offset(x13, y13, z1))).is(BlockTags.FEATURES_CANNOT_REPLACE)) continue;
                    if ((double)y13 < (double)y * 0.3 || random.nextInt(3) == 0) {
                        level.setBlock(pos, wall, 2);
                        continue;
                    }
                    if ((double)y13 > (double)y * 0.7) {
                        level.setBlock(pos, ceiling, 2);
                        continue;
                    }
                    if (random.nextInt(3) != 0) continue;
                    level.setBlock(pos, wall, 2);
                }
            }
        }
        return true;
    }

    public record Configuration(BlockStateProvider ceiling, BlockStateProvider wall, int x, int y, int z) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("ceiling_provider").forGetter(Configuration::ceiling), (App)BlockStateProvider.CODEC.fieldOf("wall_provider").forGetter(Configuration::wall), (App)Codec.intRange((int)1, (int)16).fieldOf("x").forGetter(Configuration::x), (App)Codec.intRange((int)1, (int)32).fieldOf("y").forGetter(Configuration::y), (App)Codec.intRange((int)1, (int)16).fieldOf("z").forGetter(Configuration::z)).apply((Applicative)instance, Configuration::new));
    }
}

