/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public class HugeWhiteMushroomFeature
extends AbstractHugeMushroomFeature {
    public HugeWhiteMushroomFeature(Codec<HugeMushroomFeatureConfiguration> codec) {
        super(codec);
    }

    protected void placeTrunk(LevelAccessor level, RandomSource random, BlockPos pos, HugeMushroomFeatureConfiguration config, int maxHeight, BlockPos.MutableBlockPos mutableBlockPos) {
        for (int i = 0; i < maxHeight - 1; ++i) {
            mutableBlockPos.set((Vec3i)pos).move(Direction.UP, i);
            if (level.getBlockState((BlockPos)mutableBlockPos).isSolidRender((BlockGetter)level, (BlockPos)mutableBlockPos)) continue;
            this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos, (BlockState)((BlockState)config.stemProvider.getState(random, pos).setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void makeCap(LevelAccessor level, RandomSource random, BlockPos origin, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration config) {
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        for (int y = height - 5; y <= height; ++y) {
            int stage = height - y;
            int radius = stage == 5 ? 2 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (!HugeWhiteMushroomFeature.isBlock(x, z, stage)) continue;
                    mutableBlockPos.setWithOffset((Vec3i)origin, x, y, z);
                    if (level.getBlockState((BlockPos)mutableBlockPos).isSolidRender((BlockGetter)level, (BlockPos)mutableBlockPos)) continue;
                    boolean north = z <= 0;
                    boolean south = z >= 0;
                    boolean east = x >= 0;
                    boolean west = x <= 0;
                    BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.capProvider.getState(random, origin).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(south));
                    this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos, state);
                }
            }
            if (stage != 0) continue;
            mutableBlockPos.setWithOffset((Vec3i)origin, 0, y, 0).move(direction);
            if (level.getBlockState((BlockPos)mutableBlockPos).isSolidRender((BlockGetter)level, (BlockPos)mutableBlockPos)) continue;
            BlockState state = config.capProvider.getState(random, origin);
            this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos, state);
        }
    }

    private static boolean isBlock(int x, int z, int stage) {
        int xRad = Math.abs(x);
        int zRad = Math.abs(z);
        int sum = xRad + zRad;
        if (stage == 1) {
            return sum == 0;
        }
        if (stage == 2 || stage == 3) {
            return sum < 2;
        }
        if (stage == 4) {
            return xRad < 2 && zRad < 2;
        }
        if (stage == 5) {
            return xRad == 2 != (zRad == 2) && sum < 4;
        }
        return false;
    }

    protected int getTreeHeight(RandomSource random) {
        int i = random.nextInt(3) + 7;
        if (random.nextInt(12) == 0) {
            i += 6;
        }
        return i;
    }

    protected int getTreeRadiusForHeight(int j, int height, int radius, int y) {
        if (y <= height && y >= height - 5) {
            return radius;
        }
        return 0;
    }
}

