/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.structure;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class SBProcessorLists {
    public static final ResourceKey<StructureProcessorList> REDWOOD_PATH = SBProcessorLists.createKey("redwood_path");
    public static final ResourceKey<StructureProcessorList> STONE_FLOOR = SBProcessorLists.createKey("stone_floor");

    public static void bootstrap(BootstrapContext<StructureProcessorList> context) {
        HolderGetter blocks = context.lookup(Registries.BLOCK);
        SBProcessorLists.register(context, REDWOOD_PATH, SBProcessorLists.rule(Blocks.GRAVEL, 0.4f, Blocks.COARSE_DIRT.defaultBlockState()), SBProcessorLists.rule(Blocks.GRAVEL, 0.7f, Blocks.DIRT_PATH.defaultBlockState()), SBProcessorLists.rule(Blocks.GRAVEL, 0.5f, SBBlocks.REDWOOD_PLANKS.get().defaultBlockState()));
        SBProcessorLists.register(context, STONE_FLOOR, SBProcessorLists.rule(Blocks.STONE, 0.1f, Blocks.POLISHED_ANDESITE.defaultBlockState()), SBProcessorLists.rule(Blocks.STONE, 0.1f, Blocks.SMOOTH_STONE.defaultBlockState()), SBProcessorLists.rule(Blocks.STONE, Blocks.STONE_BRICKS.defaultBlockState()));
    }

    private static ProcessorRule rule(Block block, float chance, BlockState blockState) {
        return SBProcessorLists.rule((RuleTest)new RandomBlockMatchTest(block, chance), (RuleTest)AlwaysTrueTest.INSTANCE, blockState);
    }

    private static ProcessorRule rule(TagKey<Block> tag, BlockState blockState) {
        return SBProcessorLists.rule((RuleTest)new TagMatchTest(tag), (RuleTest)AlwaysTrueTest.INSTANCE, blockState);
    }

    private static ProcessorRule rule(Block block, BlockState blockState) {
        return SBProcessorLists.rule((RuleTest)new BlockMatchTest(block), (RuleTest)AlwaysTrueTest.INSTANCE, blockState);
    }

    private static ProcessorRule rule(RuleTest blockTest, RuleTest locationTest, BlockState resultBlock) {
        return new ProcessorRule(blockTest, locationTest, resultBlock);
    }

    private static ResourceKey<StructureProcessorList> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)name));
    }

    private static void register(BootstrapContext<StructureProcessorList> context, ResourceKey<StructureProcessorList> key, ProcessorRule ... processors) {
        context.register(key, (Object)new StructureProcessorList((List)ImmutableList.of((Object)new RuleProcessor((List)ImmutableList.copyOf((Object[])processors)))));
    }
}

