/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.structure.pools;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBProcessorLists;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.pools.SBPools;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class CryptPools
extends SBPools {
    public static final ResourceKey<StructureTemplatePool> START = CryptPools.createKey("entrance");
    private static final ResourceKey<StructureTemplatePool> CORRIDOR = CryptPools.createKey("corridor");
    private static final ResourceKey<StructureTemplatePool> JUNCTION = CryptPools.createKey("junction");
    private static final ResourceKey<StructureTemplatePool> ROOM = CryptPools.createKey("room");
    private static final ResourceKey<StructureTemplatePool> WALL = CryptPools.createKey("wall");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> context) {
        HolderGetter pools = context.lookup(Registries.TEMPLATE_POOL);
        HolderGetter processors = context.lookup(Registries.PROCESSOR_LIST);
        CryptPools.register(context, START, (Holder<StructureTemplatePool>)pools.getOrThrow(Pools.EMPTY), StructureTemplatePool.Projection.RIGID, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(CryptPools.element("entrance1", 1)));
        CryptPools.register(context, CORRIDOR, (Holder<StructureTemplatePool>)pools.getOrThrow(ROOM), StructureTemplatePool.Projection.RIGID, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(CryptPools.element("corridor_0", 2), CryptPools.element("corridor_1", 1), CryptPools.element("corridor_2", 2)));
        CryptPools.register(context, JUNCTION, (Holder<StructureTemplatePool>)pools.getOrThrow(ROOM), StructureTemplatePool.Projection.RIGID, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(CryptPools.element("junction_0", 2, (Holder<StructureProcessorList>)processors.getOrThrow(SBProcessorLists.STONE_FLOOR)), CryptPools.element("junction_1", 1, (Holder<StructureProcessorList>)processors.getOrThrow(SBProcessorLists.STONE_FLOOR)), CryptPools.element("junction1", 1), CryptPools.element("junction_stair1", 1)));
        CryptPools.register(context, ROOM, (Holder<StructureTemplatePool>)pools.getOrThrow(WALL), StructureTemplatePool.Projection.RIGID, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(CryptPools.element("room_chest_0", 1, (Holder<StructureProcessorList>)processors.getOrThrow(SBProcessorLists.STONE_FLOOR)), CryptPools.element("room_spawner_0", 1)));
        CryptPools.register(context, WALL, (Holder<StructureTemplatePool>)pools.getOrThrow(Pools.EMPTY), StructureTemplatePool.Projection.RIGID, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(CryptPools.element("wall_0", 2), CryptPools.element("wall_1", 2), CryptPools.element("wall_2", 2), CryptPools.element("wall_barrels_0", 1), CryptPools.element("wall_barrels_1", 1), CryptPools.element("wall_fountain_0", 1)));
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> element(String name, int weight) {
        return CryptPools.parentElement("crypt", name, weight);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> element(String name, int weight, Holder<StructureProcessorList> processor) {
        return CryptPools.parentElement("crypt", name, weight, processor);
    }

    private static ResourceKey<StructureTemplatePool> createKey(String name) {
        return CryptPools.createParentKey("crypt", name);
    }
}

