/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts;

import java.util.Arrays;
import java.util.ServiceLoader;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.invictusslayer.scabbard.platform.IPlatformHandler;
import net.invictusslayer.slayersbeasts.config.SBConfig;
import net.invictusslayer.slayersbeasts.registries.SBBlockEntities;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBCreativeModeTabs;
import net.invictusslayer.slayersbeasts.registries.SBEffects;
import net.invictusslayer.slayersbeasts.registries.SBEntities;
import net.invictusslayer.slayersbeasts.registries.SBFeatures;
import net.invictusslayer.slayersbeasts.registries.SBFoliagePlacers;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import net.invictusslayer.slayersbeasts.registries.SBPois;
import net.invictusslayer.slayersbeasts.registries.SBPotions;
import net.invictusslayer.slayersbeasts.registries.SBSounds;
import net.invictusslayer.slayersbeasts.registries.SBStructurePieces;
import net.invictusslayer.slayersbeasts.registries.SBStructureTypes;
import net.invictusslayer.slayersbeasts.registries.SBTreeDecorators;
import net.invictusslayer.slayersbeasts.registries.SBTrunkPlacers;
import net.invictusslayer.slayersbeasts.registries.SBVillagerType;
import net.invictusslayer.slayersbeasts.world.item.SBDispensableItems;
import net.invictusslayer.slayersbeasts.world.level.biome.SBSurfaceRuleData;
import net.invictusslayer.slayersbeasts.world.level.biome.region.SBNetherRegion;
import net.invictusslayer.slayersbeasts.world.level.biome.region.SBOverworldRegion;
import net.invictusslayer.slayersbeasts.world.level.block.IExtendedMushroomBlock;
import net.invictusslayer.slayersbeasts.world.level.block.SBFlammableBlocks;
import net.invictusslayer.slayersbeasts.world.level.block.SBStrippableBlocks;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodType;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.SBConfiguredFeatures;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class SlayersBeasts {
    public static final String MOD_ID = "slayersbeasts";
    public static final Logger LOGGER = LogManager.getLogger((String)"slayersbeasts");
    public static SBConfig CONFIG = null;
    public static IPlatformHandler PLATFORM = null;

    public static void init() {
        SlayersBeasts.loadPlatform(IPlatformHandler.class);
        SlayersBeasts.loadConfig();
        SBItems.register();
        SBBlocks.register();
        SBEntities.register();
        SBCreativeModeTabs.register();
        SBVillagerType.register();
        SBBlockEntities.register();
        SBEffects.register();
        SBPotions.register();
        SBSounds.register();
        SBPois.register();
        SBFeatures.register();
        SBTreeDecorators.register();
        SBFoliagePlacers.register();
        SBTrunkPlacers.register();
        SBStructurePieces.register();
        SBStructureTypes.register();
        LOGGER.info(PLATFORM.configPath(MOD_ID).toAbsolutePath().normalize().toString());
    }

    public static void loadConfig() {
        if (CONFIG != null) {
            return;
        }
        AutoConfig.register(SBConfig.class, Toml4jConfigSerializer::new);
        CONFIG = (SBConfig)AutoConfig.getConfigHolder(SBConfig.class).getConfig();
    }

    public static <T extends IPlatformHandler> void loadPlatform(Class<T> clazz) {
        if (PLATFORM != null) {
            return;
        }
        IPlatformHandler loadedService = (IPlatformHandler)ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LOGGER.debug("Loaded {} for service {}", (Object)loadedService, clazz);
        PLATFORM = loadedService;
    }

    public static void commonSetup() {
        LOGGER.info("Extended MushroomCow$Type values: {}", (Object)Arrays.toString(MushroomCow.MushroomType.values()));
        LOGGER.info("Extended Boat$Type values: {}", (Object)Arrays.toString(Boat.Type.values()));
        LOGGER.info("Extended Fox$Type values: {}", (Object)Arrays.toString(Fox.Type.values()));
        SBFlammableBlocks.register();
        SBStrippableBlocks.register();
        SBDispensableItems.register();
        SBVillagerType.setupBiomes();
        ((IExtendedMushroomBlock)SBBlocks.BLACK_MUSHROOM.get()).setMightyMushroom(SBConfiguredFeatures.MIGHTY_BLACK_MUSHROOM);
        ((IExtendedMushroomBlock)Blocks.BROWN_MUSHROOM).setMightyMushroom(SBConfiguredFeatures.MIGHTY_BROWN_MUSHROOM);
        ((IExtendedMushroomBlock)Blocks.RED_MUSHROOM).setMightyMushroom(SBConfiguredFeatures.MIGHTY_RED_MUSHROOM);
        ((IExtendedMushroomBlock)SBBlocks.WHITE_MUSHROOM.get()).setMightyMushroom(SBConfiguredFeatures.MIGHTY_WHITE_MUSHROOM);
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)MOD_ID, (SurfaceRules.RuleSource)SBSurfaceRuleData.overworldRules());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.NETHER, (String)MOD_ID, (SurfaceRules.RuleSource)SBSurfaceRuleData.netherRules());
    }

    public static void clientSetup() {
        SBWoodType.values().forEach(type -> {
            Sheets.SIGN_MATERIALS.put(type, Sheets.createSignMaterial((WoodType)type));
            Sheets.HANGING_SIGN_MATERIALS.put(type, Sheets.createHangingSignMaterial((WoodType)type));
        });
    }

    public static void registerRegions() {
        SlayersBeasts.loadConfig();
        if (SlayersBeasts.CONFIG.worldgen.overworld_biomes) {
            Regions.register((Region)new SBOverworldRegion(SlayersBeasts.CONFIG.worldgen.overworld_region_weight));
        }
        if (SlayersBeasts.CONFIG.worldgen.nether_biomes) {
            Regions.register((Region)new SBNetherRegion(SlayersBeasts.CONFIG.worldgen.nether_region_weight));
        }
    }
}

