/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data;

import java.util.function.Consumer;
import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import net.invictusslayer.slayersbeasts.world.level.block.SBBlockFamily;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class SBRecipeProvider
extends RecipeProvider {
    public SBRecipeProvider(PackOutput output) {
        super(output);
    }

    public void buildRecipes(Consumer<FinishedRecipe> output) {
        this.generateBlockFamilies(output);
        this.generateWoodFamilies(output);
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SBItems.TIED_LEATHER.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SBItems.TANNED_LEATHER.get()), (float)0.5f, (int)200).unlockedBy("has_tied_leather", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)((ItemLike)SBItems.TIED_LEATHER.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SBItems.TIED_LEATHER.get())).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('M'), (ItemLike)SBItems.MUD_BALL.get()).pattern("MSM").pattern("LSL").pattern("MSM").unlockedBy("has_leather", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)Items.LEATHER)).save(output);
        SBRecipeProvider.twoByTwoPacker(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.PACKED_MUD, (ItemLike)SBItems.MUD_BALL.get());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.PACKED_MUD}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.CRACKED_MUD.get()), (float)0.1f, (int)200).unlockedBy("has_packed_mud", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)Blocks.PACKED_MUD)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.PEAT.get()), (int)4).define(Character.valueOf('M'), (ItemLike)Blocks.MOSS_BLOCK).define(Character.valueOf('U'), (ItemLike)Blocks.MUD).pattern("MU").pattern("UM").unlockedBy("has_moss", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)Blocks.MOSS_BLOCK)).save(output);
        SBRecipeProvider.nineBlockStorageRecipes(output, RecipeCategory.MISC, (ItemLike)SBItems.JADE.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.JADE_BLOCK.get());
        SBRecipeProvider.twoByTwoPacker(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.BLACK_SANDSTONE.get(), (ItemLike)SBBlocks.BLACK_SAND.get());
        SBRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SBBlocks.BLACK_SANDSTONE.get(), (ItemLike)SBBlocks.CHISELED_BLACK_SANDSTONE.get()})).unlockedBy("has_black_sandstone", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get()))).unlockedBy("has_chiseled_black_sandstone", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)((ItemLike)SBBlocks.CHISELED_BLACK_SANDSTONE.get()))).save(output);
        SBRecipeProvider.stairBuilder((ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SBBlocks.BLACK_SANDSTONE.get(), (ItemLike)SBBlocks.CHISELED_BLACK_SANDSTONE.get(), (ItemLike)SBBlocks.CUT_BLACK_SANDSTONE.get()})).unlockedBy("has_black_sandstone", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get()))).unlockedBy("has_chiseled_black_sandstone", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)((ItemLike)SBBlocks.CHISELED_BLACK_SANDSTONE.get()))).unlockedBy("has_cut_black_sandstone", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)((ItemLike)SBBlocks.CUT_BLACK_SANDSTONE.get()))).save(output);
        SBRecipeProvider.wall(output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE_WALL.get()), (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get()));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SBBlocks.BLACK_SANDSTONE.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.SMOOTH_BLACK_SANDSTONE.get().asItem(), (float)0.1f, (int)200).unlockedBy("has_black_sandstone", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get()))).save(output);
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE_SLAB.get()), (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get()), (int)2);
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE_STAIRS.get()), (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get()));
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE_WALL.get()), (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get()));
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.SMOOTH_BLACK_SANDSTONE_SLAB.get()), (ItemLike)((ItemLike)SBBlocks.SMOOTH_BLACK_SANDSTONE.get()), (int)2);
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.SMOOTH_BLACK_SANDSTONE_STAIRS.get()), (ItemLike)((ItemLike)SBBlocks.SMOOTH_BLACK_SANDSTONE.get()));
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.CUT_BLACK_SANDSTONE.get()), (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get()));
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.CUT_BLACK_SANDSTONE_SLAB.get()), (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get()), (int)2);
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.CUT_BLACK_SANDSTONE_SLAB.get()), (ItemLike)((ItemLike)SBBlocks.CUT_BLACK_SANDSTONE.get()), (int)2);
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.CHISELED_BLACK_SANDSTONE.get()), (ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get()));
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.PEGMATITE_SLAB.get()), (ItemLike)((ItemLike)SBBlocks.PEGMATITE.get()), (int)2);
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.PEGMATITE_STAIRS.get()), (ItemLike)((ItemLike)SBBlocks.PEGMATITE.get()));
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SBBlocks.PEGMATITE_WALL.get()), (ItemLike)((ItemLike)SBBlocks.PEGMATITE.get()));
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.POLISHED_PEGMATITE.get()), (ItemLike)((ItemLike)SBBlocks.PEGMATITE.get()));
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.POLISHED_PEGMATITE_SLAB.get()), (ItemLike)((ItemLike)SBBlocks.PEGMATITE.get()), (int)2);
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.POLISHED_PEGMATITE_SLAB.get()), (ItemLike)((ItemLike)SBBlocks.POLISHED_PEGMATITE.get()), (int)2);
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.POLISHED_PEGMATITE_STAIRS.get()), (ItemLike)((ItemLike)SBBlocks.PEGMATITE.get()));
        SBRecipeProvider.stonecutterResultFromBase(output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.POLISHED_PEGMATITE_STAIRS.get()), (ItemLike)((ItemLike)SBBlocks.POLISHED_PEGMATITE.get()));
    }

    private void generateWoodFamilies(Consumer<FinishedRecipe> output) {
        SBWoodFamily.getAllFamilies().forEach(family -> {
            Block planks = (Block)family.get(WoodFamily.Variant.PLANKS).get();
            Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{planks});
            family.getVariants().forEach((variant, supplier) -> {
                Object patt6347$temp = supplier.get();
                if (!(patt6347$temp instanceof ItemLike)) {
                    return;
                }
                ItemLike item = (ItemLike)patt6347$temp;
                switch (variant) {
                    case BOAT: {
                        SBRecipeProvider.woodenBoat((Consumer)output, (ItemLike)item, (ItemLike)planks);
                        break;
                    }
                    case BUTTON: {
                        SBRecipeProvider.woodenRecipe(output, SBRecipeProvider.buttonBuilder((ItemLike)item, (Ingredient)ingredient), planks, "button");
                        break;
                    }
                    case CHEST_BOAT: {
                        SBRecipeProvider.chestBoat((Consumer)output, (ItemLike)item, (ItemLike)((Item)family.get(WoodFamily.Variant.BOAT).get()));
                        break;
                    }
                    case DOOR: {
                        SBRecipeProvider.woodenRecipe(output, SBRecipeProvider.doorBuilder((ItemLike)item, (Ingredient)ingredient), planks, "door");
                        break;
                    }
                    case FENCE: {
                        SBRecipeProvider.woodenRecipe(output, SBRecipeProvider.fenceBuilder((ItemLike)item, (Ingredient)ingredient), planks, "fence");
                        break;
                    }
                    case FENCE_GATE: {
                        SBRecipeProvider.woodenRecipe(output, SBRecipeProvider.fenceGateBuilder((ItemLike)item, (Ingredient)ingredient), planks, "fence_gate");
                        break;
                    }
                    case HANGING_SIGN_ITEM: {
                        SBRecipeProvider.hangingSign((Consumer)output, (ItemLike)item, (ItemLike)((Block)family.get(WoodFamily.Variant.STRIPPED_LOG).get()));
                        break;
                    }
                    case PLANKS: {
                        SBRecipeProvider.planksFromLog((Consumer)output, (ItemLike)item, (TagKey)family.getLogItems(), (int)4);
                        break;
                    }
                    case PRESSURE_PLATE: {
                        SBRecipeProvider.woodenRecipe(output, SBRecipeProvider.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)item, (Ingredient)ingredient), planks, "pressure_plate");
                        break;
                    }
                    case SIGN_ITEM: {
                        SBRecipeProvider.woodenRecipe(output, SBRecipeProvider.signBuilder((ItemLike)item, (Ingredient)ingredient), planks, "sign");
                        break;
                    }
                    case SLAB: {
                        SBRecipeProvider.woodenRecipe(output, SBRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (Ingredient)ingredient), planks, "slab");
                        break;
                    }
                    case STAIRS: {
                        SBRecipeProvider.woodenRecipe(output, SBRecipeProvider.stairBuilder((ItemLike)item, (Ingredient)ingredient), planks, "stairs");
                        break;
                    }
                    case STRIPPED_WOOD: {
                        SBRecipeProvider.woodFromLogs((Consumer)output, (ItemLike)item, (ItemLike)((Block)family.get(WoodFamily.Variant.STRIPPED_LOG).get()));
                        break;
                    }
                    case TRAPDOOR: {
                        SBRecipeProvider.woodenRecipe(output, SBRecipeProvider.trapdoorBuilder((ItemLike)item, (Ingredient)ingredient), planks, "trapdoor");
                        break;
                    }
                    case WOOD: {
                        SBRecipeProvider.woodFromLogs((Consumer)output, (ItemLike)item, (ItemLike)((Block)family.get(WoodFamily.Variant.LOG).get()));
                    }
                }
            });
        });
    }

    private static void woodenRecipe(Consumer<FinishedRecipe> output, RecipeBuilder builder, Block planks, String group) {
        builder.unlockedBy("has_planks", (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)planks)).group("wooden_" + group).save(output);
    }

    private void generateBlockFamilies(Consumer<FinishedRecipe> output) {
        SBBlockFamily.getAllFamilies().filter(family -> family.shouldGenerateRecipe(FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA))).forEach(family -> SBRecipeProvider.generateRecipes((Consumer)output, (BlockFamily)family));
    }

    public static void twoByTwoPacker(Consumer<FinishedRecipe> output, RecipeCategory category, ItemLike pPacked, ItemLike pUnpacked) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)pPacked, (int)1).define(Character.valueOf('#'), pUnpacked).pattern("##").pattern("##").unlockedBy(SBRecipeProvider.getHasName((ItemLike)pUnpacked), (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)pUnpacked)).save(output, new ResourceLocation("slayersbeasts", SBRecipeProvider.getSimpleRecipeName((ItemLike)pUnpacked)));
    }

    public static void nineBlockStorageRecipes(Consumer<FinishedRecipe> output, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed) {
        SBRecipeProvider.nineBlockStorageRecipes(output, unpackedCategory, unpacked, packedCategory, packed, SBRecipeProvider.getSimpleRecipeName((ItemLike)packed), SBRecipeProvider.getSimpleRecipeName((ItemLike)unpacked));
    }

    protected static void nineBlockStorageRecipes(Consumer<FinishedRecipe> output, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String packedName, String unpackedName) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)unpackedCategory, (ItemLike)unpacked, (int)9).requires(packed).group(null).unlockedBy(SBRecipeProvider.getHasName((ItemLike)packed), (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)packed)).save(output, new ResourceLocation("slayersbeasts", unpackedName));
        ShapedRecipeBuilder.shaped((RecipeCategory)packedCategory, (ItemLike)packed).define(Character.valueOf('#'), unpacked).pattern("###").pattern("###").pattern("###").group(null).unlockedBy(SBRecipeProvider.getHasName((ItemLike)unpacked), (CriterionTriggerInstance)SBRecipeProvider.has((ItemLike)unpacked)).save(output, new ResourceLocation("slayersbeasts", packedName));
    }
}

