/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.mixin.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.invictusslayer.slayersbeasts.world.entity.vehicle.SBBoatType;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BoatRenderer.class})
public abstract class BoatRendererMixin {
    @Shadow
    @Final
    @Mutable
    private Map<Boat.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources;

    @Shadow
    private static String getTextureLocation(Boat.Type type, boolean chestBoat) {
        if (chestBoat) {
            return "textures/entity/chest_boat/" + type.getName() + ".png";
        }
        return "textures/entity/boat/" + type.getName() + ".png";
    }

    @Shadow
    protected abstract ListModel<Boat> createBoatModel(EntityRendererProvider.Context var1, Boat.Type var2, boolean var3);

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onInit(EntityRendererProvider.Context context, boolean chestBoat, CallbackInfo ci) {
        this.boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)this.getTexture((Boat.Type)type, chestBoat), this.createBoatModel(context, (Boat.Type)type, chestBoat))));
    }

    @Unique
    private ResourceLocation getTexture(Boat.Type type, boolean chestBoat) {
        for (Boat.Type boatType : SBBoatType.values()) {
            if (boatType != type) continue;
            return new ResourceLocation("slayersbeasts", BoatRendererMixin.getTextureLocation(type, chestBoat));
        }
        return new ResourceLocation(BoatRendererMixin.getTextureLocation(type, chestBoat));
    }
}

