/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.entity;

import java.util.function.IntFunction;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class AbstractEnt
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(AbstractEnt.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public AbstractEnt(EntityType<? extends AbstractEnt> type, Level level) {
        super(type, level);
    }

    public void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.GRASS_HIT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WOOD_FALL;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.WOOD_BREAK;
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getVariant().getId());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(Variant.byId(tag.getInt("Variant")));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    protected abstract void setupAnimationStates();

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, SpawnGroupData spawnData, CompoundTag tag) {
        Variant variant = this.getRandomEntType((LevelAccessor)level);
        if (spawnData instanceof EntGroupData) {
            EntGroupData antData = (EntGroupData)spawnData;
            variant = antData.variant;
        } else {
            spawnData = new EntGroupData(variant);
        }
        this.setVariant(variant);
        return spawnData;
    }

    private Variant getRandomEntType(LevelAccessor level) {
        Holder holder = level.getBiome(this.blockPosition());
        if (holder.is(SBTags.Biomes.SPAWNS_OAK_ENTS)) {
            return Variant.OAK;
        }
        if (holder.is(SBTags.Biomes.SPAWNS_BIRCH_ENTS)) {
            return Variant.BIRCH;
        }
        return Variant.byId(level.getRandom().nextInt(Variant.values().length));
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT));
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_VARIANT, (Object)variant.ordinal());
    }

    public static enum Variant implements StringRepresentable
    {
        OAK(0, "oak"),
        BIRCH(1, "birch"),
        JUNGLE(2, "jungle");

        private static final IntFunction<Variant> BY_ID;
        final int id;
        final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public int getId() {
            return this.id;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public static class EntGroupData
    implements SpawnGroupData {
        private final Variant variant;

        private EntGroupData(Variant variant) {
            this.variant = variant;
        }
    }
}

