/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.entity;

import java.util.EnumSet;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class Damselfly
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(Damselfly.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_IS_FLYING = SynchedEntityData.defineId(Damselfly.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_PERCHED = SynchedEntityData.defineId(Damselfly.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState flyAnimationState = new AnimationState();
    public final AnimationState perchAnimationState = new AnimationState();
    BlockPos savedPerchPos;
    private int ticksUntilPerch;

    public Damselfly(EntityType<Damselfly> type, Level level) {
        super(type, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.navigation = this.createNavigation(level);
        this.resetTicksUntilPerch();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new DamselflyPerchGoal(this));
        this.goalSelector.addGoal(1, (Goal)new DamselflyWanderGoal(this));
        this.goalSelector.addGoal(2, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new DamselflyHoverGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FLYING_SPEED, 0.4);
    }

    public static boolean canSpawn(EntityType<Damselfly> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return PathfinderMob.checkMobSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, SpawnGroupData spawnData, CompoundTag tag) {
        this.setVariant(Variant.byId(level.getRandom().nextInt(Variant.values().length)));
        return new DamselflyGroupData();
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(false);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    public void travel(Vec3 vec3) {
        if (this.isEffectiveAi() || this.isControlledByLocalInstance()) {
            this.moveRelative(this.getSpeed(), vec3);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.savedPerchPos != null) {
            tag.put("PerchPos", (Tag)NbtUtils.writeBlockPos((BlockPos)this.savedPerchPos));
        }
        tag.putInt("TicksSincePerch", this.ticksUntilPerch);
        tag.putInt("Variant", this.getVariant().getId());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.savedPerchPos = tag.contains("PerchPos") ? NbtUtils.readBlockPos((CompoundTag)tag.getCompound("PerchPos")) : null;
        this.ticksUntilPerch = tag.getInt("TicksSincePerch");
        this.setVariant(Variant.byId(tag.getInt("Variant")));
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_VARIANT, (Object)0);
        this.entityData.define(DATA_IS_FLYING, (Object)false);
        this.entityData.define(DATA_IS_PERCHED, (Object)false);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT));
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_VARIANT, (Object)variant.ordinal());
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(DATA_IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.entityData.set(DATA_IS_FLYING, (Object)flying);
    }

    public boolean isPerched() {
        return (Boolean)this.entityData.get(DATA_IS_PERCHED);
    }

    public void setPerched(boolean perched) {
        this.entityData.set(DATA_IS_PERCHED, (Object)perched);
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public void resetTicksUntilPerch() {
        this.ticksUntilPerch = 100 + this.getRandom().nextInt(100);
    }

    boolean isTooFarAway(Vec3 pos) {
        return !pos.closerThan((Position)this.position(), 32.0);
    }

    public void tick() {
        super.tick();
        if (!this.isPerched()) {
            --this.ticksUntilPerch;
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.flyAnimationState.animateWhen(this.isFlying(), this.tickCount);
        this.perchAnimationState.animateWhen(this.isPerched(), this.tickCount);
    }

    static class DamselflyPerchGoal
    extends Goal {
        private final Damselfly mob;
        private int perchTicks;
        private Vec3 perchPos;
        private final Predicate<BlockState> VALID_PERCH_BLOCKS = state -> {
            if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                return false;
            }
            if (state.is(Blocks.TALL_GRASS)) {
                return state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER;
            }
            return false;
        };

        DamselflyPerchGoal(Damselfly mob) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean canUse() {
            if (this.mob.ticksUntilPerch > 0) {
                return false;
            }
            Optional<BlockPos> optional = this.findNearbyPerch();
            if (optional.isPresent()) {
                this.mob.savedPerchPos = optional.get();
                this.perchPos = Vec3.atBottomCenterOf((Vec3i)this.mob.savedPerchPos).add(0.0, 1.0, 0.0);
                this.perchTicks = 120 + this.mob.getRandom().nextInt(80);
                return true;
            }
            this.mob.resetTicksUntilPerch();
            return false;
        }

        public boolean canContinueToUse() {
            return this.perchTicks > 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void stop() {
            this.mob.setPerched(false);
            this.mob.setFlying(true);
            this.mob.resetTicksUntilPerch();
        }

        public void tick() {
            if (this.mob.savedPerchPos == null) {
                this.perchTicks = 0;
            }
            if (this.mob.position().distanceTo(this.perchPos) <= 0.1) {
                this.mob.setFlying(false);
                this.mob.setPerched(true);
                --this.perchTicks;
            } else if (this.mob.navigation.isDone()) {
                if (this.mob.isTooFarAway(this.perchPos)) {
                    this.mob.savedPerchPos = null;
                } else {
                    this.mob.setFlying(true);
                    this.mob.setPerched(false);
                    this.mob.navigation.moveTo(this.mob.navigation.createPath(new BlockPos((int)this.perchPos.x, (int)this.perchPos.y, (int)this.perchPos.z), 1), 1.0);
                    this.setWantedPos();
                }
            }
        }

        private void setWantedPos() {
            this.mob.getMoveControl().setWantedPosition(this.perchPos.x, this.perchPos.y, this.perchPos.z, 0.4);
        }

        private Optional<BlockPos> findNearbyPerch() {
            return this.findNearestBlock(this.VALID_PERCH_BLOCKS);
        }

        private Optional<BlockPos> findNearestBlock(Predicate<BlockState> predicate) {
            BlockPos blockPos = this.mob.blockPosition();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int y = 0;
            while (y <= 5) {
                for (int i = 0; i < 5; ++i) {
                    int x = 0;
                    while (x <= i) {
                        int z;
                        int n = z = x < i && x > -i ? i : 0;
                        while (z <= i) {
                            mutableBlockPos.setWithOffset((Vec3i)blockPos, x, y - 1, z);
                            if (blockPos.closerThan((Vec3i)mutableBlockPos, 5.0) && predicate.test(this.mob.level().getBlockState((BlockPos)mutableBlockPos))) {
                                return Optional.of(mutableBlockPos);
                            }
                            z = z > 0 ? -z : 1 - z;
                        }
                        x = x > 0 ? -x : 1 - x;
                    }
                }
                y = y > 0 ? -y : 1 - y;
            }
            return Optional.empty();
        }
    }

    class DamselflyWanderGoal
    extends Goal {
        private final Damselfly mob;

        DamselflyWanderGoal(Damselfly mob) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean canUse() {
            return this.mob.navigation.isDone() && this.mob.random.nextInt(20) == 0;
        }

        public boolean canContinueToUse() {
            return this.mob.navigation.isInProgress();
        }

        public void start() {
            this.mob.setFlying(true);
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                this.mob.navigation.moveTo(this.mob.navigation.createPath(new BlockPos((int)vec3.x, (int)vec3.y, (int)vec3.z), 1), 1.0);
            }
        }

        private Vec3 findPos() {
            Vec3 vec3 = Damselfly.this.getViewVector(0.0f);
            Vec3 pos = HoverRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)7, (double)vec3.x, (double)vec3.z, (float)1.5707964f, (int)3, (int)1);
            return pos != null ? pos : AirAndWaterRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)4, (int)-2, (double)vec3.x, (double)vec3.z, (double)1.5707963705062866);
        }
    }

    static class DamselflyHoverGoal
    extends Goal {
        private final Damselfly mob;
        private int hoverTime;

        DamselflyHoverGoal(Damselfly mob) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean canUse() {
            return this.mob.navigation.isDone();
        }

        public boolean canContinueToUse() {
            return this.mob.navigation.isDone() && this.hoverTime >= 0;
        }

        public void start() {
            this.mob.setFlying(true);
            this.hoverTime = 40 + this.mob.getRandom().nextInt(40);
        }

        public void tick() {
            --this.hoverTime;
        }
    }

    public static enum Variant implements StringRepresentable
    {
        BLUE(0, "blue"),
        GREEN(1, "green"),
        YELLOW(2, "yellow");

        private static final IntFunction<Variant> BY_ID;
        final int id;
        final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public int getId() {
            return this.id;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public static class DamselflyGroupData
    implements SpawnGroupData {
        private DamselflyGroupData() {
        }
    }
}

