/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.block;

import java.util.List;
import net.invictusslayer.slayersbeasts.registries.SBBlockEntities;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.world.entity.AntSoldier;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class AnthillBlock
extends BaseEntityBlock {
    public static final IntegerProperty FUNGUS_LEVEL = IntegerProperty.create((String)"fungus_level", (int)0, (int)5);
    public static final IntegerProperty SUPPLY_LEVEL = IntegerProperty.create((String)"supply_level", (int)0, (int)10);

    public AnthillBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FUNGUS_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)SUPPLY_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FUNGUS_LEVEL, SUPPLY_LEVEL});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AnthillBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return AnthillBlock.createTickerHelper(type, SBBlockEntities.ANTHILL.get(), AnthillBlockEntity::serverTick);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public static void dropMushroom(Level level, BlockPos pos) {
        AnthillBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)SBBlocks.WHITE_MUSHROOM.get(), level.random.nextInt(1, 4)));
    }

    public void angerNearbyAnts(Level level, BlockPos pos) {
        List list = level.getEntitiesOfClass(AntSoldier.class, new AABB(pos).inflate(8.0, 6.0, 8.0));
        if (!list.isEmpty()) {
            List players = level.getEntitiesOfClass(Player.class, new AABB(pos).inflate(8.0, 6.0, 8.0));
            if (players.isEmpty()) {
                return;
            }
            int i = players.size();
            for (AntSoldier ant : list) {
                if (ant.getTarget() != null) continue;
                ant.setTarget((LivingEntity)players.get(level.random.nextInt(i)));
            }
        }
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack handItem = player.getItemInHand(hand);
        int i = (Integer)state.getValue((Property)FUNGUS_LEVEL);
        boolean flag = false;
        if (i >= 5) {
            Item item = handItem.getItem();
            if (!level.isClientSide && flag) {
                player.awardStat(Stats.ITEM_USED.get((Object)item));
            }
        }
        if (flag) {
            if (this.nestContainsAnts(level, pos)) {
                this.angerNearbyAnts(level, pos);
            }
            this.releaseAntsAndResetMushroomLevel(level, state, pos, player, AnthillBlockEntity.AntReleaseStatus.EMERGENCY);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.use(state, level, pos, player, hand, result);
    }

    private boolean nestContainsAnts(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AnthillBlockEntity) {
            AnthillBlockEntity anthillBlockEntity = (AnthillBlockEntity)blockEntity;
            return !anthillBlockEntity.isEmpty();
        }
        return false;
    }

    public void releaseAntsAndResetMushroomLevel(Level level, BlockState state, BlockPos pos, Player player, AnthillBlockEntity.AntReleaseStatus releaseStatus) {
        this.resetMushroomLevel(level, state, pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AnthillBlockEntity) {
            AnthillBlockEntity anthillBlockEntity = (AnthillBlockEntity)blockEntity;
            anthillBlockEntity.emptyAntsFromNest(player, state, releaseStatus);
        }
    }

    public void resetMushroomLevel(Level level, BlockState state, BlockPos pos) {
        level.setBlock(pos, (BlockState)state.setValue((Property)FUNGUS_LEVEL, (Comparable)Integer.valueOf(0)), 3);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack item) {
        super.playerDestroy(level, player, pos, state, blockEntity, item);
        if (!level.isClientSide && blockEntity instanceof AnthillBlockEntity) {
            AnthillBlockEntity anthillBlockEntity = (AnthillBlockEntity)blockEntity;
            anthillBlockEntity.emptyAntsFromNest(player, state, AnthillBlockEntity.AntReleaseStatus.EMERGENCY);
            this.angerNearbyAnts(level, pos);
        }
    }

    public void playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && player.isCreative() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (blockEntity = level.getBlockEntity(pos)) instanceof AnthillBlockEntity) {
            boolean flag;
            AnthillBlockEntity anthillBlockEntity = (AnthillBlockEntity)blockEntity;
            int i = (Integer)state.getValue((Property)FUNGUS_LEVEL);
            int j = (Integer)state.getValue((Property)SUPPLY_LEVEL);
            boolean bl = flag = !anthillBlockEntity.isEmpty();
            if (flag || i > 0 || j > 0) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                if (flag) {
                    CompoundTag compoundTag = new CompoundTag();
                    compoundTag.put("Ants", (Tag)anthillBlockEntity.writeAnts());
                    BlockItem.setBlockEntityData((ItemStack)itemStack, SBBlockEntities.ANTHILL.get(), (CompoundTag)compoundTag);
                }
                CompoundTag compoundTag1 = new CompoundTag();
                compoundTag1.putInt("fungus_level", i);
                compoundTag1.putInt("supply_level", j);
                itemStack.addTagElement("BlockStateTag", (Tag)compoundTag1);
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemStack);
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
            }
        }
        super.playerWillDestroy(level, pos, state, player);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity;
        Entity entity = (Entity)builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if ((entity instanceof PrimedTnt || entity instanceof Creeper || entity instanceof WitherSkull || entity instanceof WitherBoss || entity instanceof MinecartTNT) && (blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof AnthillBlockEntity) {
            AnthillBlockEntity anthillBlockEntity = (AnthillBlockEntity)blockEntity;
            anthillBlockEntity.emptyAntsFromNest(null, state, AnthillBlockEntity.AntReleaseStatus.EMERGENCY);
        }
        return super.getDrops(state, builder);
    }
}

