/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.SBConfiguredFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.VeryBiasedToBottomHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class SBPlacedFeatures {
    public static final ResourceKey<PlacedFeature> ASPEN = SBPlacedFeatures.createKey("aspen");
    public static final ResourceKey<PlacedFeature> SUPER_ASPEN = SBPlacedFeatures.createKey("super_aspen");
    public static final ResourceKey<PlacedFeature> BLOODWOOD = SBPlacedFeatures.createKey("bloodwood");
    public static final ResourceKey<PlacedFeature> CAJOLE = SBPlacedFeatures.createKey("cajole");
    public static final ResourceKey<PlacedFeature> CYPRESS = SBPlacedFeatures.createKey("cypress");
    public static final ResourceKey<PlacedFeature> DESERT_OAK = SBPlacedFeatures.createKey("desert_oak");
    public static final ResourceKey<PlacedFeature> SUPER_DESERT_OAK = SBPlacedFeatures.createKey("super_desert_oak");
    public static final ResourceKey<PlacedFeature> EUCALYPTUS = SBPlacedFeatures.createKey("eucalyptus");
    public static final ResourceKey<PlacedFeature> GIANT_KAPOK = SBPlacedFeatures.createKey("giant_kapok");
    public static final ResourceKey<PlacedFeature> REDWOOD = SBPlacedFeatures.createKey("redwood");
    public static final ResourceKey<PlacedFeature> GIANT_REDWOOD = SBPlacedFeatures.createKey("giant_redwood");
    public static final ResourceKey<PlacedFeature> COLOSSAL_REDWOOD = SBPlacedFeatures.createKey("colossal_redwood");
    public static final ResourceKey<PlacedFeature> ALBINO_REDWOOD = SBPlacedFeatures.createKey("albino_redwood");
    public static final ResourceKey<PlacedFeature> GIANT_ALBINO_REDWOOD = SBPlacedFeatures.createKey("giant_albino_redwood");
    public static final ResourceKey<PlacedFeature> GIANT_WILLOW = SBPlacedFeatures.createKey("giant_willow");
    public static final ResourceKey<PlacedFeature> TREES_ASPEN = SBPlacedFeatures.createKey("trees_aspen");
    public static final ResourceKey<PlacedFeature> TREES_BAYOU = SBPlacedFeatures.createKey("trees_bayou");
    public static final ResourceKey<PlacedFeature> TREES_BRUSH = SBPlacedFeatures.createKey("trees_brush");
    public static final ResourceKey<PlacedFeature> TREES_WOODED_BRUSH = SBPlacedFeatures.createKey("trees_wooded_brush");
    public static final ResourceKey<PlacedFeature> TREES_CHAPARRAL = SBPlacedFeatures.createKey("trees_chaparral");
    public static final ResourceKey<PlacedFeature> TREES_EUCALYPT = SBPlacedFeatures.createKey("trees_eucalypt");
    public static final ResourceKey<PlacedFeature> TREES_INKY = SBPlacedFeatures.createKey("trees_inky");
    public static final ResourceKey<PlacedFeature> TREES_MUSHROOM = SBPlacedFeatures.createKey("trees_mushroom");
    public static final ResourceKey<PlacedFeature> TREES_OUTBACK = SBPlacedFeatures.createKey("trees_outback");
    public static final ResourceKey<PlacedFeature> TREES_RAINFOREST = SBPlacedFeatures.createKey("trees_rainforest");
    public static final ResourceKey<PlacedFeature> TREES_REDWOOD = SBPlacedFeatures.createKey("trees_redwood");
    public static final ResourceKey<PlacedFeature> TREES_OLD_GROWTH_REDWOOD = SBPlacedFeatures.createKey("trees_old_growth_redwood");
    public static final ResourceKey<PlacedFeature> TREES_RIVER = SBPlacedFeatures.createKey("trees_river");
    public static final ResourceKey<PlacedFeature> PATCH_ALGAE_COMMON = SBPlacedFeatures.createKey("patch_algae_common");
    public static final ResourceKey<PlacedFeature> PATCH_ALGAE_NORMAL = SBPlacedFeatures.createKey("patch_algae_normal");
    public static final ResourceKey<PlacedFeature> PATCH_TALL_DEAD_BUSH = SBPlacedFeatures.createKey("patch_tall_dead_bush");
    public static final ResourceKey<PlacedFeature> PATCH_TALL_DEAD_BUSH_BRUSH = SBPlacedFeatures.createKey("patch_tall_dead_bush_brush");
    public static final ResourceKey<PlacedFeature> BLACK_MUSHROOM_COMMON = SBPlacedFeatures.createKey("black_mushroom_common");
    public static final ResourceKey<PlacedFeature> BLACK_MUSHROOM_RARE = SBPlacedFeatures.createKey("black_mushroom_rare");
    public static final ResourceKey<PlacedFeature> WHITE_MUSHROOM_COMMON = SBPlacedFeatures.createKey("white_mushroom_common");
    public static final ResourceKey<PlacedFeature> WHITE_MUSHROOM_RARE = SBPlacedFeatures.createKey("white_mushroom_rare");
    public static final ResourceKey<PlacedFeature> ICICLE_CLUSTER = SBPlacedFeatures.createKey("icicle_cluster");
    public static final ResourceKey<PlacedFeature> ICICLE_LARGE = SBPlacedFeatures.createKey("icicle_large");
    public static final ResourceKey<PlacedFeature> ICICLE_SMALL = SBPlacedFeatures.createKey("icicle_small");
    public static final ResourceKey<PlacedFeature> STYPHIUM_PATCH = SBPlacedFeatures.createKey("styphium_patch");
    public static final ResourceKey<PlacedFeature> ORE_EXOSKELETON = SBPlacedFeatures.createKey("ore_exoskeleton");
    public static final ResourceKey<PlacedFeature> ORE_EXOSKELETON_LUSH = SBPlacedFeatures.createKey("ore_exoskeleton_lush");
    public static final ResourceKey<PlacedFeature> ORE_OBSIDIAN = SBPlacedFeatures.createKey("ore_obsidian");
    public static final ResourceKey<PlacedFeature> ORE_PEGMATITE_UPPER = SBPlacedFeatures.createKey("ore_pegmatite_upper");
    public static final ResourceKey<PlacedFeature> ORE_PEGMATITE_LOWER = SBPlacedFeatures.createKey("ore_pegmatite_lower");
    public static final ResourceKey<PlacedFeature> ORE_BASALT_VOLCANIC = SBPlacedFeatures.createKey("ore_basalt_volcanic");
    public static final ResourceKey<PlacedFeature> ORE_GRANITE_VOLCANIC = SBPlacedFeatures.createKey("ore_granite_volcanic");
    public static final ResourceKey<PlacedFeature> ORE_PEGMATITE_VOLCANIC = SBPlacedFeatures.createKey("ore_pegmatite_volcanic");
    public static final ResourceKey<PlacedFeature> ANT_MOUND_MUD = SBPlacedFeatures.createKey("and_mound_mud");
    public static final ResourceKey<PlacedFeature> ANT_MOUND_RUDOSOL = SBPlacedFeatures.createKey("and_mound_rudosol");
    public static final ResourceKey<PlacedFeature> MUD_PIT_SHALLOW = SBPlacedFeatures.createKey("mud_pit_shallow");
    public static final ResourceKey<PlacedFeature> MUD_PIT_NORMAL = SBPlacedFeatures.createKey("mud_pit_normal");
    public static final ResourceKey<PlacedFeature> MUD_PIT_DEEP = SBPlacedFeatures.createKey("mud_pit_deep");
    public static final ResourceKey<PlacedFeature> LAKE_LAVA_VOLCANIC = SBPlacedFeatures.createKey("lake_lava_volcanic");
    public static final ResourceKey<PlacedFeature> SPRING_LAVA_VOLCANIC = SBPlacedFeatures.createKey("spring_lava_volcanic");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configured = context.lookup(Registries.CONFIGURED_FEATURE);
        SBPlacedFeatures.register(context, ASPEN, configured.getOrThrow(SBConfiguredFeatures.ASPEN), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.ASPEN_SAPLING.get())});
        SBPlacedFeatures.register(context, SUPER_ASPEN, configured.getOrThrow(SBConfiguredFeatures.SUPER_ASPEN), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.ASPEN_SAPLING.get())});
        SBPlacedFeatures.register(context, BLOODWOOD, configured.getOrThrow(SBConfiguredFeatures.BLOODWOOD), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.BLOODWOOD_SAPLING.get())});
        SBPlacedFeatures.register(context, CAJOLE, configured.getOrThrow(SBConfiguredFeatures.CAJOLE), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.CAJOLE_SAPLING.get())});
        SBPlacedFeatures.register(context, CYPRESS, configured.getOrThrow(SBConfiguredFeatures.CYPRESS), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.CYPRESS_SAPLING.get())});
        SBPlacedFeatures.register(context, DESERT_OAK, configured.getOrThrow(SBConfiguredFeatures.DESERT_OAK), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.DESERT_OAK_SAPLING.get())});
        SBPlacedFeatures.register(context, SUPER_DESERT_OAK, configured.getOrThrow(SBConfiguredFeatures.SUPER_DESERT_OAK), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.DESERT_OAK_SAPLING.get())});
        SBPlacedFeatures.register(context, EUCALYPTUS, configured.getOrThrow(SBConfiguredFeatures.EUCALYPTUS), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.EUCALYPTUS_SAPLING.get())});
        SBPlacedFeatures.register(context, GIANT_KAPOK, configured.getOrThrow(SBConfiguredFeatures.GIANT_KAPOK), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.KAPOK_SAPLING.get())});
        SBPlacedFeatures.register(context, REDWOOD, configured.getOrThrow(SBConfiguredFeatures.REDWOOD), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.REDWOOD_SAPLING.get())});
        SBPlacedFeatures.register(context, GIANT_REDWOOD, configured.getOrThrow(SBConfiguredFeatures.GIANT_REDWOOD), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.REDWOOD_SAPLING.get())});
        SBPlacedFeatures.register(context, COLOSSAL_REDWOOD, configured.getOrThrow(SBConfiguredFeatures.COLOSSAL_REDWOOD), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.REDWOOD_SAPLING.get())});
        SBPlacedFeatures.register(context, ALBINO_REDWOOD, configured.getOrThrow(SBConfiguredFeatures.ALBINO_REDWOOD), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.ALBINO_REDWOOD_SAPLING.get())});
        SBPlacedFeatures.register(context, GIANT_ALBINO_REDWOOD, configured.getOrThrow(SBConfiguredFeatures.GIANT_ALBINO_REDWOOD), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.ALBINO_REDWOOD_SAPLING.get())});
        SBPlacedFeatures.register(context, GIANT_WILLOW, configured.getOrThrow(SBConfiguredFeatures.GIANT_WILLOW), new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)SBBlocks.WILLOW_SAPLING.get())});
        SBPlacedFeatures.register(context, TREES_ASPEN, configured.getOrThrow(SBConfiguredFeatures.TREES_ASPEN), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.2f, (int)3), (Block)SBBlocks.ASPEN_SAPLING.get()));
        SBPlacedFeatures.register(context, TREES_BAYOU, configured.getOrThrow(SBConfiguredFeatures.TREES_BAYOU), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.2f, (int)2)));
        SBPlacedFeatures.register(context, TREES_BRUSH, configured.getOrThrow(SBConfiguredFeatures.TREES_BRUSH), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.1f, (int)1), (Block)SBBlocks.DESERT_OAK_SAPLING.get()));
        SBPlacedFeatures.register(context, TREES_WOODED_BRUSH, configured.getOrThrow(SBConfiguredFeatures.TREES_BRUSH), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.2f, (int)3), (Block)SBBlocks.DESERT_OAK_SAPLING.get()));
        SBPlacedFeatures.register(context, TREES_CHAPARRAL, configured.getOrThrow(SBConfiguredFeatures.TREES_CHAPARRAL), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.1f, (int)1), (Block)SBBlocks.DESERT_OAK_SAPLING.get()));
        SBPlacedFeatures.register(context, TREES_EUCALYPT, configured.getOrThrow(SBConfiguredFeatures.TREES_EUCALYPT), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)6, (float)0.1f, (int)1), (Block)SBBlocks.EUCALYPTUS_SAPLING.get()));
        SBPlacedFeatures.register(context, TREES_INKY, configured.getOrThrow(SBConfiguredFeatures.TREES_INKY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)3, (float)0.1f, (int)1)));
        SBPlacedFeatures.register(context, TREES_MUSHROOM, configured.getOrThrow(SBConfiguredFeatures.TREES_MUSHROOM), new PlacementModifier[]{CountPlacement.of((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, TREES_OUTBACK, configured.getOrThrow(SBConfiguredFeatures.TREES_OUTBACK), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.1f, (int)1), (Block)SBBlocks.EUCALYPTUS_SAPLING.get()));
        SBPlacedFeatures.register(context, TREES_RAINFOREST, configured.getOrThrow(SBConfiguredFeatures.TREES_RAINFOREST), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.1f, (int)1)));
        SBPlacedFeatures.register(context, TREES_REDWOOD, configured.getOrThrow(SBConfiguredFeatures.TREES_REDWOOD), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.1f, (int)1), (Block)SBBlocks.REDWOOD_SAPLING.get()));
        SBPlacedFeatures.register(context, TREES_OLD_GROWTH_REDWOOD, configured.getOrThrow(SBConfiguredFeatures.TREES_OLD_GROWTH_REDWOOD), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.1f, (int)1), (Block)SBBlocks.REDWOOD_SAPLING.get()));
        SBPlacedFeatures.register(context, TREES_RIVER, configured.getOrThrow(SBConfiguredFeatures.TREES_RIVER), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.05f, (int)1), (Block)SBBlocks.WILLOW_SAPLING.get()));
        SBPlacedFeatures.register(context, PATCH_ALGAE_COMMON, configured.getOrThrow(SBConfiguredFeatures.PATCH_ALGAE), VegetationPlacements.worldSurfaceSquaredWithCount((int)5));
        SBPlacedFeatures.register(context, PATCH_ALGAE_NORMAL, configured.getOrThrow(SBConfiguredFeatures.PATCH_ALGAE), VegetationPlacements.worldSurfaceSquaredWithCount((int)1));
        SBPlacedFeatures.register(context, PATCH_TALL_DEAD_BUSH, configured.getOrThrow(SBConfiguredFeatures.PATCH_TALL_DEAD_BUSH), new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, PATCH_TALL_DEAD_BUSH_BRUSH, configured.getOrThrow(SBConfiguredFeatures.PATCH_TALL_DEAD_BUSH), VegetationPlacements.worldSurfaceSquaredWithCount((int)20));
        SBPlacedFeatures.register(context, BLACK_MUSHROOM_COMMON, configured.getOrThrow(SBConfiguredFeatures.PATCH_BLACK_MUSHROOM), SBPlacedFeatures.mushroomPlacement(9, (PlacementModifier)CountPlacement.of((int)3)));
        SBPlacedFeatures.register(context, BLACK_MUSHROOM_RARE, configured.getOrThrow(SBConfiguredFeatures.PATCH_BLACK_MUSHROOM), SBPlacedFeatures.mushroomPlacement(256, null));
        SBPlacedFeatures.register(context, WHITE_MUSHROOM_COMMON, configured.getOrThrow(SBConfiguredFeatures.PATCH_WHITE_MUSHROOM), SBPlacedFeatures.mushroomPlacement(9, (PlacementModifier)CountPlacement.of((int)3)));
        SBPlacedFeatures.register(context, WHITE_MUSHROOM_RARE, configured.getOrThrow(SBConfiguredFeatures.PATCH_WHITE_MUSHROOM), SBPlacedFeatures.mushroomPlacement(256, null));
        SBPlacedFeatures.register(context, ICICLE_CLUSTER, configured.getOrThrow(SBConfiguredFeatures.ICICLE_CLUSTER), new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)48, (int)96)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, ICICLE_LARGE, configured.getOrThrow(SBConfiguredFeatures.ICICLE_LARGE), new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)10, (int)48)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, ICICLE_SMALL, configured.getOrThrow(SBConfiguredFeatures.ICICLE_SMALL), new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)192, (int)256)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, CountPlacement.of((IntProvider)UniformInt.of((int)1, (int)5)), RandomOffsetPlacement.of((IntProvider)ClampedNormalInt.of((float)0.0f, (float)3.0f, (int)-10, (int)10), (IntProvider)ClampedNormalInt.of((float)0.0f, (float)0.6f, (int)-2, (int)2)), BiomeFilter.biome()});
        SBPlacedFeatures.register(context, STYPHIUM_PATCH, configured.getOrThrow(SBConfiguredFeatures.STYPHIUM_PATCH), new PlacementModifier[]{CountPlacement.of((int)256), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, ORE_EXOSKELETON, configured.getOrThrow(SBConfiguredFeatures.ORE_EXOSKELETON), SBPlacedFeatures.rareOrePlacement(1, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        SBPlacedFeatures.register(context, ORE_EXOSKELETON_LUSH, configured.getOrThrow(SBConfiguredFeatures.ORE_EXOSKELETON), SBPlacedFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64))));
        SBPlacedFeatures.register(context, ORE_OBSIDIAN, configured.getOrThrow(SBConfiguredFeatures.ORE_OBSIDIAN), SBPlacedFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)160))));
        SBPlacedFeatures.register(context, ORE_PEGMATITE_UPPER, configured.getOrThrow(SBConfiguredFeatures.ORE_PEGMATITE), SBPlacedFeatures.rareOrePlacement(12, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)64), (VerticalAnchor)VerticalAnchor.absolute((int)128))));
        SBPlacedFeatures.register(context, ORE_PEGMATITE_LOWER, configured.getOrThrow(SBConfiguredFeatures.ORE_PEGMATITE), SBPlacedFeatures.commonOrePlacement(1, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)60))));
        SBPlacedFeatures.register(context, ORE_BASALT_VOLCANIC, configured.getOrThrow(SBConfiguredFeatures.ORE_BASALT), SBPlacedFeatures.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)160))));
        SBPlacedFeatures.register(context, ORE_GRANITE_VOLCANIC, configured.getOrThrow(OreFeatures.ORE_GRANITE), SBPlacedFeatures.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)160))));
        SBPlacedFeatures.register(context, ORE_PEGMATITE_VOLCANIC, configured.getOrThrow(SBConfiguredFeatures.ORE_PEGMATITE), SBPlacedFeatures.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)160))));
        SBPlacedFeatures.register(context, ANT_MOUND_MUD, configured.getOrThrow(SBConfiguredFeatures.ANT_MOUND_MUD), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, ANT_MOUND_RUDOSOL, configured.getOrThrow(SBConfiguredFeatures.ANT_MOUND_RUDOSOL), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, MUD_PIT_SHALLOW, configured.getOrThrow(SBConfiguredFeatures.MUD_PIT_SHALLOW), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, MUD_PIT_NORMAL, configured.getOrThrow(SBConfiguredFeatures.MUD_PIT_NORMAL), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, MUD_PIT_DEEP, configured.getOrThrow(SBConfiguredFeatures.MUD_PIT_DEEP), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)9), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, LAKE_LAVA_VOLCANIC, configured.getOrThrow(SBConfiguredFeatures.LAKE_LAVA_VOLCANIC), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        SBPlacedFeatures.register(context, SPRING_LAVA_VOLCANIC, configured.getOrThrow(SBConfiguredFeatures.SPRING_LAVA_VOLCANIC), new PlacementModifier[]{CountPlacement.of((int)20), InSquarePlacement.spread(), HeightRangePlacement.of((HeightProvider)VeryBiasedToBottomHeight.of((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.belowTop((int)8), (int)8)), BiomeFilter.biome()});
    }

    private static List<PlacementModifier> mushroomPlacement(int rarity, PlacementModifier modifier) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (modifier != null) {
            builder.add((Object)modifier);
        }
        if (rarity != 0) {
            builder.add((Object)RarityFilter.onAverageOnceEvery((int)rarity));
        }
        builder.add((Object[])new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        return builder.build();
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier rarity, PlacementModifier modifier) {
        return List.of(rarity, InSquarePlacement.spread(), modifier, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int veinsPerChunk, PlacementModifier modifier) {
        return SBPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)veinsPerChunk), modifier);
    }

    private static List<PlacementModifier> rareOrePlacement(int chunksPerVein, PlacementModifier modifier) {
        return SBPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)chunksPerVein), modifier);
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)new ResourceLocation("slayersbeasts", name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> config, PlacementModifier ... modifiers) {
        SBPlacedFeatures.register(context, key, config, List.of(modifiers));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> config, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(config, modifiers));
    }
}

