/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.registries.SBFoliagePlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class StackedFoliagePlacer
extends FoliagePlacer {
    public static final Codec<StackedFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> StackedFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and((App)Codec.intRange((int)1, (int)5).fieldOf("stacks").forGetter(placer -> placer.stacks)).apply((Applicative)instance, StackedFoliagePlacer::new));
    private final int stacks;

    public StackedFoliagePlacer(IntProvider radius, IntProvider offset, int stacks) {
        super(radius, offset);
        this.stacks = stacks;
    }

    protected FoliagePlacerType<?> type() {
        return SBFoliagePlacers.STACKED_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        boolean flag = attachment.doubleTrunk();
        BlockPos blockPos = attachment.pos().above(offset);
        int r = foliageRadius + attachment.radiusOffset();
        int h = -this.stacks * 4;
        this.placeLeavesRow(level, blockSetter, random, config, blockPos, r - 2, h - 1, flag);
        this.placeLeavesRow(level, blockSetter, random, config, blockPos, r - 1, h, flag);
        for (int i = 0; i < this.stacks; ++i) {
            int j = -4 * i;
            this.placeLeavesRow(level, blockSetter, random, config, blockPos, r, j - 3, flag);
            this.placeLeavesRow(level, blockSetter, random, config, blockPos, r, j - 2, flag);
            this.placeLeavesRow(level, blockSetter, random, config, blockPos, r, j - 1, flag);
            this.placeLeavesRow(level, blockSetter, random, config, blockPos, r - 1, j, flag);
        }
        this.placeLeavesRow(level, blockSetter, random, config, blockPos, r - 2, 1, flag);
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return 0;
    }

    protected boolean shouldSkipLocation(RandomSource random, int x, int y, int z, int range, boolean large) {
        return x + z > range || x > 2 || z > 2;
    }
}

