/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.trunk;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.invictusslayer.slayersbeasts.registries.SBTrunkPlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class ColossalTrunkPlacer
extends TrunkPlacer {
    public static final Codec<ColossalTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)60).fieldOf("base_height").forGetter(placer -> placer.baseHeight), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(placer -> placer.heightRandA), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(placer -> placer.heightRandB)).apply((Applicative)instance, ColossalTrunkPlacer::new));
    protected final int baseHeight;
    protected final int heightRandA;
    protected final int heightRandB;

    public ColossalTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
        this.baseHeight = baseHeight;
        this.heightRandA = heightRandA;
        this.heightRandB = heightRandB;
    }

    protected TrunkPlacerType<?> type() {
        return SBTrunkPlacers.COLOSSAL_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        for (int i = 1; i <= 2; ++i) {
            BlockPos dirtPos = pos.relative(Direction.DOWN, i);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos, (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.east(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.east().east(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.south(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.south().east(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.south().east().east(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.south().south(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.south().south().east(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.south().south().east().east(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.south().west(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.north().east(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.south().south().south().east(), (TreeConfiguration)config);
            ColossalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)dirtPos.south().east().east().east(), (TreeConfiguration)config);
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int root = 3 + random.nextInt(5);
        int base = root + 4 + random.nextInt(5);
        int top = 3 + random.nextInt(3);
        for (int i = 0; i < freeTreeHeight; ++i) {
            if (i < root) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, -1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, -1, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 3);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 3, i, 1);
            }
            if (i < base) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 2);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 2);
            }
            if (i < freeTreeHeight - top) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 2);
            }
            this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 1);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.above(freeTreeHeight).south().east(), 0, false));
    }

    private void placeLogIfFreeWithOffset(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos.MutableBlockPos pos, TreeConfiguration config, BlockPos origin, int x, int y, int z) {
        pos.setWithOffset((Vec3i)origin, x, y, z);
        this.placeLogIfFree(level, blockSetter, random, pos, config);
    }
}

