/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.structure;

import java.util.Map;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.world.level.biome.SBBiomes;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.pools.CryptPools;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.pools.RedwoodLodgePools;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.structures.CryptPortalStructure;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.structures.CryptStructure;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public class SBStructures {
    public static final ResourceKey<Structure> CRYPT = SBStructures.createKey("crypt");
    public static final ResourceKey<Structure> CRYPT_PORTAL = SBStructures.createKey("crypt_portal");
    public static final ResourceKey<Structure> REDWOOD_LODGE = SBStructures.createKey("redwood_lodge");

    public static void bootstrap(BootstapContext<Structure> context) {
        HolderGetter pools = context.lookup(Registries.TEMPLATE_POOL);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(CRYPT, (Object)new CryptStructure(SBStructures.structure((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(SBBiomes.THE_CRYPT)}), Map.of(), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE), (Holder<StructureTemplatePool>)pools.getOrThrow(CryptPools.START), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)60))));
        context.register(CRYPT_PORTAL, (Object)new CryptPortalStructure(SBStructures.structure((HolderSet<Biome>)biomes.getOrThrow(SBTags.Biomes.HAS_CRYPT_PORTAL), TerrainAdjustment.BEARD_THIN)));
        context.register(REDWOOD_LODGE, (Object)new JigsawStructure(SBStructures.structure((HolderSet<Biome>)biomes.getOrThrow(SBTags.Biomes.HAS_REDWOOD_LODGE), TerrainAdjustment.BEARD_THIN), (Holder)pools.getOrThrow(RedwoodLodgePools.START), 3, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG));
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> biomes, Map<MobCategory, StructureSpawnOverride> spawns, GenerationStep.Decoration step, TerrainAdjustment terrain) {
        return new Structure.StructureSettings(biomes, spawns, step, terrain);
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> biomes, TerrainAdjustment terrain) {
        return SBStructures.structure(biomes, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, terrain);
    }

    private static ResourceKey<Structure> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)new ResourceLocation("slayersbeasts", name));
    }
}

