/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.structure.structures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.invictusslayer.slayersbeasts.registries.SBStructureTypes;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.pieces.CryptPortalPieces;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class CryptPortalStructure
extends Structure {
    public static final Codec<CryptPortalStructure> CODEC = CryptPortalStructure.simpleCodec(CryptPortalStructure::new);

    public CryptPortalStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        BlockPos blockPos = this.getLowestYIn5by5BoxOffset7Blocks(context, Rotation.NONE);
        return blockPos.getY() < 62 ? Optional.empty() : Optional.of(new Structure.GenerationStub(blockPos, builder -> this.generatePieces((StructurePiecesBuilder)builder, context, blockPos)));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockPos blockPos) {
        CryptPortalPieces.addPieces(builder, (RandomSource)context.random(), blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public StructureType<?> type() {
        return SBStructureTypes.CRYPT_PORTAL.get();
    }
}

