/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.events;

import com.nukateam.nukacraft.client.helpers.ExplosionUtils;
import com.nukateam.nukacraft.common.data.utils.ExplosionType;
import com.nukateam.nukacraft.common.foundation.entities.misc.NuclearExplosionEffectEntity;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nukacraft", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeEvents {
    @SubscribeEvent
    public static void computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        float tremorAmount;
        Minecraft minecraft = Minecraft.m_91087_();
        Entity player = minecraft.m_91288_();
        ArrayList<NuclearExplosionEffectEntity> nukes = ExplosionUtils.getNukesAround();
        if (player == null || nukes.isEmpty()) {
            return;
        }
        NuclearExplosionEffectEntity nuke = nukes.get(0);
        ExplosionType explosionType = nuke.getExplosionType();
        float f = tremorAmount = nuke.tremorFor > 0 ? explosionType.getTremorIntensity() : 0.0f;
        if (tremorAmount > 0.0f) {
            if (ExplosionUtils.lastTremorTick != player.f_19797_) {
                ExplosionUtils.lastTremorTick = player.f_19797_;
            }
            double intensity = ForgeEvents.scaleTremor(tremorAmount, explosionType) * (Double)minecraft.f_91066_.m_231924_().m_231551_();
            intensity *= (double)nuke.getTremorIntensity();
            Camera camera = event.getCamera();
            RandomSource rng = player.m_9236_().f_46441_;
            try {
                Method move = Camera.class.getDeclaredMethod("move", Double.TYPE, Double.TYPE, Double.TYPE);
                move.setAccessible(true);
                move.invoke((Object)camera, (double)(rng.m_188501_() * 0.2f) * intensity, (double)(rng.m_188501_() * 0.2f) * intensity, (double)(rng.m_188501_() * 0.5f) * intensity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static double getFraction(double value, double maxValue) {
        return value / maxValue;
    }

    public static double scaleTremor(double tremor, ExplosionType explosionType) {
        Double distance = ExplosionUtils.getDistanceToNearestExplosion();
        if (distance == null) {
            return 0.0;
        }
        return tremor - tremor * ForgeEvents.getFraction(distance, explosionType.getTremorDistance());
    }
}

