/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.helpers;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.model.GeoModel;

public class AnimationHelper<T extends GeoAnimatable> {
    private final T animatable;
    private final GeoModel model;

    public AnimationHelper(T animatable, GeoModel model) {
        this.animatable = animatable;
        this.model = model;
    }

    public void syncAnimation(AnimationState event, String animationName, int duration) {
        float multiplier = (float)this.getSpeedMultiplier(animationName, duration);
        event.setControllerSpeed(multiplier);
    }

    public double getSpeedMultiplier(String animationName, double targetDuration) {
        double duration = this.getAnimationDuration(animationName);
        return duration / targetDuration;
    }

    public double getAnimationDuration(String animationName) {
        Animation animation = this.getAnimation(animationName);
        return animation != null ? animation.length() : 1.0;
    }

    public boolean containsAnimation(String animationName) {
        return this.getAnimation(animationName) != null;
    }

    @Nullable
    public Animation getAnimation(String animationName) {
        Map map = GeckoLibCache.getBakedAnimations();
        ResourceLocation animationResource = this.model.getAnimationResource(this.animatable);
        BakedAnimations bakedAnimations = (BakedAnimations)map.get(animationResource);
        return (Animation)bakedAnimations.animations().get(animationName);
    }

    public boolean hasAnimation(String animationName) {
        return this.getAnimation(animationName) != null;
    }
}

