/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.render.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.nukacraft.common.data.utils.PowerArmorUtils;
import com.nukateam.nukacraft.common.data.utils.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class PowerArmorHud {
    private static final int BAR_OFFSET_X = 95;
    private static final ResourceLocation DURABILITY_SENSOR = Resources.nukaResource("textures/gui/hud/durability/durability_sensor.png");
    private static final ResourceLocation DURABILITY_ARROW = Resources.nukaResource("textures/gui/hud/durability/durability_flag.png");
    private static final ResourceLocation DURABILITY_HELMET = Resources.nukaResource("textures/gui/hud/durability/helmet_indicator.png");
    private static final ResourceLocation DURABILITY_CHEST = Resources.nukaResource("textures/gui/hud/durability/chest_indicator.png");
    private static final ResourceLocation DURABILITY_L_HAND = Resources.nukaResource("textures/gui/hud/durability/left_hand_indicator.png");
    private static final ResourceLocation DURABILITY_R_HAND = Resources.nukaResource("textures/gui/hud/durability/right_hand_indicator.png");
    private static final ResourceLocation DURABILITY_L_LEG = Resources.nukaResource("textures/gui/hud/durability/left_leg_indicator.png");
    private static final ResourceLocation DURABILITY_R_LEG = Resources.nukaResource("textures/gui/hud/durability/right_leg_indicator.png");
    private static final ResourceLocation POWER_SENSOR = Resources.nukaResource("textures/gui/hud/energy/power_sensor.png");
    private static final ResourceLocation POWER_ARROW = Resources.nukaResource("textures/gui/hud/energy/power_flag.png");
    private static final ResourceLocation NO_POWER = Resources.nukaResource("textures/gui/hud/energy/empty.png");
    private static final ResourceLocation LOW_POWER = Resources.nukaResource("textures/gui/hud/energy/low_power.png");
    private static final ResourceLocation WORK = Resources.nukaResource("textures/gui/hud/energy/work.png");
    private static final ResourceLocation[] INDICATORS = new ResourceLocation[]{DURABILITY_HELMET, DURABILITY_CHEST, DURABILITY_L_HAND, DURABILITY_R_HAND, DURABILITY_L_LEG, DURABILITY_R_LEG};
    public static final IGuiOverlay POWER_ARMOR_HUD = (gui, graphics, partialTick, width, height) -> {
        if (!PowerArmorUtils.isLocalWearingPowerArmor()) {
            return;
        }
        WearableChassis frame = PowerArmorUtils.getPowerArmor();
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        ItemStack core = frame.inventory.m_8020_(6);
        float coreDamage = core.m_41773_();
        float coreMaxDamage = core.m_41776_();
        int maxXPos = 95;
        float chargePercent = coreDamage / coreMaxDamage;
        int xPos = (int)((float)maxXPos * chargePercent);
        graphics.m_280163_(DURABILITY_SENSOR, -4, height - 127, 0.0f, 0.0f, 128, 127, 128, 127);
        graphics.m_280163_(DURABILITY_ARROW, 60, height - 24, 0.0f, 0.0f, 5, 6, 5, 6);
        graphics.m_280163_(POWER_SENSOR, width - 128, height - 127, 0.0f, 0.0f, 128, 127, 128, 127);
        graphics.m_280163_(POWER_ARROW, width - 104 + xPos, height - 23, 0.0f, 0.0f, 5, 9, 5, 9);
        for (int i = 0; i < 6; ++i) {
            ItemStack item = frame.inventory.m_8020_(i);
            if (item.m_41619_() || item.m_41773_() >= item.m_41776_()) continue;
            PowerArmorHud.setIndicatorColor(item);
            graphics.m_280163_(INDICATORS[i], -4, height - 127, 0.0f, 0.0f, 128, 127, 128, 127);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (!core.m_41619_()) {
            graphics.m_280163_(WORK, width - 56, height - 50, 0.0f, 0.0f, 11, 21, 11, 21);
            if (core.m_41773_() >= core.m_41776_() / 3 * 2) {
                graphics.m_280163_(LOW_POWER, width - 36, height - 50, 0.0f, 0.0f, 11, 21, 11, 21);
            }
        } else {
            graphics.m_280163_(NO_POWER, width - 16, height - 50, 0.0f, 0.0f, 11, 21, 11, 21);
        }
    };

    private static void blit(GuiGraphics gui, ResourceLocation resourceLocation, int pX1, int pX2, int pY1, int pY2, int pUWidth, int pVHeight) {
        gui.m_280163_(resourceLocation, pX1, pX2, (float)pY1, (float)pY2, pUWidth, pVHeight, pUWidth, pVHeight);
    }

    private static void setIndicatorColor(ItemStack stack) {
        int part;
        int damage = stack.m_41773_();
        if (damage < (part = stack.m_41776_() / 3)) {
            RenderSystem.setShaderColor((float)0.2f, (float)0.5f, (float)0.2f, (float)1.0f);
        } else if (damage < part * 2) {
            RenderSystem.setShaderColor((float)0.9f, (float)0.8f, (float)0.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)0.8f, (float)0.1f, (float)0.1f, (float)1.0f);
        }
    }
}

