/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.render.gui.pipboy;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nukateam.nukacraft.client.render.gui.pipboy.MainPipBoyButton;
import com.nukateam.nukacraft.client.render.gui.pipboy.TextPipBoyButton;
import com.nukateam.nukacraft.common.data.archives.ArchiveManager;
import com.nukateam.nukacraft.common.data.archives.PipBoyArchives;
import com.nukateam.nukacraft.common.data.archives.pages.ImagePage;
import com.nukateam.nukacraft.common.data.archives.pages.Page;
import com.nukateam.nukacraft.common.data.archives.pages.TextPage;
import com.nukateam.nukacraft.common.data.utils.PipBoyUtils;
import com.nukateam.nukacraft.common.data.utils.Resources;
import com.nukateam.nukacraft.common.foundation.container.PipBoyMenu;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PipBoyScreen
extends AbstractContainerScreen<PipBoyMenu> {
    int ARCHIVE_PER_PAGE = 9;
    private int CURRENT_PAGE;
    private int ARCHIVE_PAGES;
    private int CURRENT_LIST;
    private String title;
    private String description;
    private List<Page> list_of_pages;
    private int scrollOffset = 0;
    private boolean isScrollable = false;
    private boolean monocolor = false;
    public static final ResourceLocation RAD_MARKER = Resources.nukaResource("textures/screens/rad_marker.png");
    private static final ResourceLocation PIPBOY_FRAME = Resources.nukaResource("textures/screens/pipboy_template.png");
    private static final ResourceLocation PIPBOY_SCREEN = Resources.nukaResource("textures/screens/pipboy_screen.png");
    private static final ResourceLocation ROBCO_TITLE = Resources.nukaResource("textures/screens/robco_title.png");
    private static ResourceLocation PAGE_IMAGE = Resources.nukaResource("textures/screens/archives_image/empty.png");
    private static PipboyPage page = PipboyPage.ARCHIVE;
    private final List<PipBoyArchives> content = ArchiveManager.getArchivesMap();
    private static ResourceLocation pipboy;
    private final Minecraft minecraft = Minecraft.m_91087_();

    public PipBoyScreen(PipBoyMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 0;
        this.f_97727_ = 0;
    }

    public void m_7856_() {
        super.m_7856_();
        this.clearTextField();
        PAGE_IMAGE = Resources.nukaResource("textures/screens/archives_image/empty.png");
        page = PipboyPage.ARCHIVE;
        pipboy = PipBoyUtils.getPipboySkin((Player)this.minecraft.f_91074_);
        this.renderButtons();
        this.ARCHIVE_PAGES = (this.content.size() + this.ARCHIVE_PER_PAGE - 1) / this.ARCHIVE_PER_PAGE;
        this.CURRENT_PAGE = 1;
        this.renderArchive();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        PipBoyUtils.setPipboyShader();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280163_(PIPBOY_FRAME, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        graphics.m_280163_(PIPBOY_SCREEN, this.f_97735_ + -163, this.f_97736_ + -113, 0.0f, 0.0f, 327, 207, 327, 207);
        if (page == PipboyPage.ARCHIVE) {
            graphics.m_280163_(ROBCO_TITLE, this.f_97735_ + -158, this.f_97736_ + -97, 0.0f, 0.0f, 225, 23, 225, 23);
        }
        if (!this.monocolor) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280163_(PAGE_IMAGE, this.f_97735_ + -153, this.f_97736_ + -80, 0.0f, 0.0f, 215, 85, 215, 85);
        } else {
            PipBoyUtils.setPipboyShader();
            graphics.m_280163_(PAGE_IMAGE, this.f_97735_ + -153, this.f_97736_ + -80, 0.0f, 0.0f, 215, 85, 215, 85);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280163_(pipboy, this.f_97735_ + -163, this.f_97736_ + -113, 0.0f, 0.0f, 327, 207, 327, 207);
        int radX = this.f_97735_ + 91 + PipBoyUtils.getPlayerRads((Player)this.minecraft.f_91074_) * 3;
        graphics.m_280163_(RAD_MARKER, radX, this.f_97736_ + 72, 0.0f, 0.0f, 3, 4, 3, 4);
    }

    public boolean m_7933_(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(key, b, c);
    }

    public void m_181908_() {
        super.m_181908_();
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = -92;
        int lineHeight = 13;
        int maxWidth = 200;
        int fontColor = PipBoyUtils.getScreenColor((Player)this.minecraft.f_91074_).getIntColor();
        int text_line_count = 0;
        int text_offset_y = 0;
        switch (page) {
            case ARCHIVE: {
                MutableComponent text = Component.m_237115_((String)("   [" + this.CURRENT_PAGE + "/" + this.ARCHIVE_PAGES + "]"));
                graphics.m_280614_(this.f_96547_, (Component)text, -25, 64, -1, false);
                break;
            }
            case RADIO: {
                MutableComponent text = Component.m_237115_((String)"[No Info]");
                graphics.m_280614_(this.f_96547_, (Component)text, -25, 64, -1, false);
                break;
            }
            case MAP: {
                MutableComponent text = Component.m_237115_((String)"[No Info]");
                graphics.m_280614_(this.f_96547_, (Component)text, -25, 64, -1, false);
                break;
            }
            case PAGE: {
                MutableComponent text = Component.m_237115_((String)("   [" + (this.CURRENT_LIST + 1) + "/" + this.list_of_pages.size() + "]"));
                graphics.m_280614_(this.f_96547_, (Component)text, -25, 64, -1, false);
                text_line_count = 10;
                text_offset_y = 14;
                break;
            }
            case IMAGE: {
                MutableComponent text = Component.m_237115_((String)("   [" + (this.CURRENT_LIST + 1) + "/" + this.list_of_pages.size() + "]"));
                graphics.m_280614_(this.f_96547_, (Component)text, -25, 64, -1, false);
                text_line_count = 3;
                text_offset_y = 103;
                break;
            }
            default: {
                MutableComponent text = Component.m_237115_((String)"[No Info]");
                graphics.m_280614_(this.f_96547_, (Component)text, -25, 64, -1, false);
            }
        }
        if (this.title != null) {
            MutableComponent titleText = Component.m_237115_((String)this.title);
            graphics.m_280614_(this.f_96547_, (Component)titleText, -150, startY + lineHeight - 13, fontColor, false);
        }
        if (this.description != null) {
            MutableComponent discriptText = Component.m_237115_((String)this.description);
            String longText = discriptText.getString();
            List lines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)longText), maxWidth);
            int maxScrollOffset = Math.max(0, lines.size() - text_line_count);
            this.isScrollable = maxScrollOffset > 0;
            this.scrollOffset = Math.min(this.scrollOffset, maxScrollOffset);
            this.scrollOffset = Math.max(0, this.scrollOffset);
            int currentLine = 0;
            for (int i = this.scrollOffset; i < lines.size() && currentLine < text_line_count; ++currentLine, ++i) {
                FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
                graphics.m_280649_(this.f_96547_, line, -150, startY + currentLine * lineHeight + text_offset_y, fontColor, false);
            }
            if (this.isScrollable) {
                int scrollBarHeight = (int)((float)text_line_count / (float)lines.size() * 100.0f);
                int scrollBarY = (int)((float)this.scrollOffset / (float)maxScrollOffset * (float)(100 - scrollBarHeight));
                graphics.m_280315_(-150 + maxWidth + 15, startY + scrollBarY, startY + scrollBarY + scrollBarHeight + 32, fontColor);
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isScrollable) {
            this.scrollOffset -= (int)Math.signum(delta);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void renderButtons() {
        this.m_142416_((GuiEventListener)this.getArchiveButton());
        this.m_142416_((GuiEventListener)this.getMapButton());
        this.m_142416_((GuiEventListener)this.getOffButton());
        this.m_142416_((GuiEventListener)this.getRadioButton());
    }

    private MainPipBoyButton getMapButton() {
        return new MainPipBoyButton(this.f_97735_ + 125, this.f_97736_ + -71, 14, 14, (Component)Component.m_237113_((String)""), e -> {
            PAGE_IMAGE = Resources.nukaResource("textures/screens/archives_image/empty.png");
            this.m_169413_();
            page = PipboyPage.MAP;
            this.renderButtons();
            this.clearTextField();
        });
    }

    private void clearTextField() {
        this.title = "";
        this.description = "";
    }

    private MainPipBoyButton getArchiveButton() {
        return new MainPipBoyButton(this.f_97735_ + 125, this.f_97736_ + -94, 14, 14, (Component)Component.m_237113_((String)""), e -> {
            PAGE_IMAGE = Resources.nukaResource("textures/screens/archives_image/empty.png");
            this.m_169413_();
            page = PipboyPage.ARCHIVE;
            this.CURRENT_PAGE = 1;
            this.renderButtons();
            this.renderArchive();
            this.clearTextField();
        });
    }

    private MainPipBoyButton getRadioButton() {
        return new MainPipBoyButton(this.f_97735_ + 125, this.f_97736_ + -48, 14, 14, (Component)Component.m_237113_((String)""), e -> {
            PAGE_IMAGE = Resources.nukaResource("textures/screens/archives_image/empty.png");
            this.m_169413_();
            page = PipboyPage.RADIO;
            this.CURRENT_PAGE = 1;
            this.renderButtons();
            this.clearTextField();
        });
    }

    private MainPipBoyButton getOffButton() {
        return new MainPipBoyButton(this.f_97735_ + -156, this.f_97736_ + 61, 14, 14, (Component)Component.m_237113_((String)""), e -> this.minecraft.f_91074_.m_6915_());
    }

    public void m_7379_() {
        super.m_7379_();
    }

    private void renderPage() {
        Page targetPage = this.list_of_pages.get(this.CURRENT_LIST);
        if (targetPage instanceof TextPage) {
            TextPage textPage = (TextPage)targetPage;
            page = PipboyPage.PAGE;
            this.title = textPage.getTitle();
            this.description = textPage.getDescription();
            PAGE_IMAGE = Resources.nukaResource("textures/screens/archives_image/empty.png");
        }
        if (targetPage instanceof ImagePage) {
            ImagePage imagePage = (ImagePage)targetPage;
            page = PipboyPage.IMAGE;
            this.title = imagePage.getTitle();
            this.description = imagePage.getDescription();
            PAGE_IMAGE = Resources.nukaResource("textures/screens/archives_image/" + imagePage.getImage() + ".png");
            this.monocolor = imagePage.getMono();
        }
        this.m_142416_((GuiEventListener)this.getBackButton(() -> {
            if (this.CURRENT_LIST > 0) {
                --this.CURRENT_LIST;
                this.m_169413_();
                this.renderPage();
                this.renderButtons();
            }
        }));
        this.m_142416_((GuiEventListener)this.getForwardButton(() -> {
            if (this.CURRENT_LIST != this.list_of_pages.size() - 1) {
                ++this.CURRENT_LIST;
                this.m_169413_();
                this.renderPage();
                this.renderButtons();
            }
        }));
    }

    private void renderArchive() {
        this.CURRENT_LIST = 0;
        int list_size = this.content.size();
        this.ARCHIVE_PAGES = (list_size + this.ARCHIVE_PER_PAGE - 1) / this.ARCHIVE_PER_PAGE;
        int list_index = 0;
        if (this.CURRENT_PAGE == this.ARCHIVE_PAGES) {
            list_index = list_size % this.ARCHIVE_PER_PAGE == 0 ? this.ARCHIVE_PER_PAGE : list_size % this.ARCHIVE_PER_PAGE;
        } else if (list_size >= this.ARCHIVE_PER_PAGE) {
            list_index = this.ARCHIVE_PER_PAGE;
        }
        for (int t = 0; t < list_index; ++t) {
            int finalIndex = this.CURRENT_PAGE > 1 ? t + (this.CURRENT_PAGE - 1) * 9 : t;
            String archiveName = "\u25aa " + Component.m_237115_((String)this.content.get(finalIndex).getName()).getString();
            PipBoyArchives targetArchive = ArchiveManager.getArchivesMap().get(finalIndex);
            if (!ArchiveManager.getOpenAchievements(targetArchive.getCriteria())) continue;
            this.m_142416_((GuiEventListener)new TextPipBoyButton(this.f_97735_ + -150, this.f_97736_ + (-69 + t * 13), 209, 11, (Component)Component.m_237113_((String)archiveName), e -> {
                this.m_169413_();
                this.list_of_pages = targetArchive.getEntries();
                this.renderPage();
                this.renderButtons();
            }));
        }
        this.m_142416_((GuiEventListener)this.getBackButton(() -> {
            if (this.CURRENT_PAGE > 1) {
                --this.CURRENT_PAGE;
                this.m_169413_();
                this.renderArchive();
                this.renderButtons();
            }
        }));
        this.m_142416_((GuiEventListener)this.getForwardButton(() -> {
            if (this.CURRENT_PAGE != this.ARCHIVE_PAGES) {
                ++this.CURRENT_PAGE;
                this.m_169413_();
                this.renderArchive();
                this.renderButtons();
            }
        }));
    }

    private MainPipBoyButton getBackButton(Runnable runnable) {
        return new MainPipBoyButton(this.f_97735_ + -71, this.f_97736_ + 61, 14, 14, (Component)Component.m_237113_((String)""), e -> runnable.run());
    }

    private MainPipBoyButton getForwardButton(Runnable runnable) {
        return new MainPipBoyButton(this.f_97735_ + 52, this.f_97736_ + 61, 14, 14, (Component)Component.m_237113_((String)""), e -> runnable.run());
    }

    public static enum PipboyPage {
        ARCHIVE,
        MAP,
        RADIO,
        PAGE,
        IMAGE;

    }
}

