/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.data.archives;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nukateam.nukacraft.NukaCraft;
import com.nukateam.nukacraft.common.data.archives.PipBoyArchives;
import com.nukateam.nukacraft.common.data.archives.pages.ImagePage;
import com.nukateam.nukacraft.common.data.archives.pages.Page;
import com.nukateam.nukacraft.common.data.archives.pages.TextPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nukacraft")
public class ArchiveManager
extends SimplePreparableReloadListener<List<PipBoyArchives>> {
    private static ArchiveManager instance;
    static List<PipBoyArchives> entriesList;

    protected List<PipBoyArchives> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.loadData(resourceManager);
    }

    public static List<PipBoyArchives> getArchivesMap() {
        return entriesList;
    }

    protected void apply(List<PipBoyArchives> stringPipBoyArchivesMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
    }

    public List<PipBoyArchives> loadData(ResourceManager manager) {
        entriesList.clear();
        Map resources = manager.m_214159_("pipboy_archives", location -> location.m_135815_().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation location2 = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            String fileName = ArchiveManager.getFileNameFromLocation(location2);
            try {
                InputStream inputStream = resource.m_215507_();
                try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    JsonObject entriesJson = json.getAsJsonObject("entries");
                    String name = json.has("name") ? json.get("name").getAsString() : fileName;
                    String criteria = json.has("criteria") ? json.get("criteria").getAsString() : "";
                    PipBoyArchives archives = new PipBoyArchives(name, criteria);
                    for (Map.Entry entryElement : entriesJson.entrySet()) {
                        Page page;
                        JsonObject entryData = ((JsonElement)entryElement.getValue()).getAsJsonObject();
                        if (entryData.get("type").getAsString().equals("text")) {
                            page = new TextPage(entryData.get("type").getAsString(), entryData.get("title").getAsString(), entryData.get("description").getAsString());
                            archives.addEntry(page);
                        }
                        if (!entryData.get("type").getAsString().equals("image")) continue;
                        page = new ImagePage(entryData.get("type").getAsString(), entryData.get("title").getAsString(), entryData.get("description").getAsString(), entryData.get("image").getAsString(), entryData.get("mono").getAsBoolean());
                        archives.addEntry(page);
                    }
                    entriesList.add(archives);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                NukaCraft.LOGGER.error("Failed to load pipboy archive: {}", (Object)location2, (Object)e);
            }
        }
        return entriesList;
    }

    private static String getFileNameFromLocation(ResourceLocation location) {
        String path = location.m_135815_();
        path = path.substring("pipboy_archives/".length(), path.length() - 5);
        return path.replace('/', '.');
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        ArchiveManager archiveManager = new ArchiveManager();
        event.addListener((PreparableReloadListener)archiveManager);
        instance = archiveManager;
    }

    public static boolean getOpenPages(Player player, String name) {
        if (name.isEmpty()) {
            return true;
        }
        CompoundTag persistentData = player.getPersistentData();
        if (!persistentData.m_128441_("nukacraft")) {
            return false;
        }
        CompoundTag modData = persistentData.m_128469_("nukacraft");
        return modData.m_128425_(name, 8);
    }

    public static boolean getOpenAchievements(String location) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        AdvancementList advancementList = minecraft.m_91403_().m_105145_().m_104396_();
        Advancement advancement = advancementList.m_139337_(new ResourceLocation(location));
        return advancement != null;
    }

    static {
        entriesList = new ArrayList<PipBoyArchives>();
    }
}

